% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_alpha.R
\name{trans_alpha}
\alias{trans_alpha}
\title{Create \code{trans_alpha} object for alpha diversity statistics and visualization.}
\description{
This class is a wrapper for a series of alpha diversity analysis, including the statistics and visualization.
}
\examples{

## ------------------------------------------------
## Method `trans_alpha$new`
## ------------------------------------------------

\donttest{
data(dataset)
t1 <- trans_alpha$new(dataset = dataset, group = "Group")
}

## ------------------------------------------------
## Method `trans_alpha$cal_diff`
## ------------------------------------------------

\donttest{
t1$cal_diff(method = "KW")
t1$cal_diff(method = "anova")
t1 <- trans_alpha$new(dataset = dataset, group = "Type", by_group = "Group")
t1$cal_diff(method = "anova")
}

## ------------------------------------------------
## Method `trans_alpha$plot_alpha`
## ------------------------------------------------

\donttest{
t1 <- trans_alpha$new(dataset = dataset, group = "Group")
t1$cal_diff(method = "wilcox")
t1$plot_alpha(measure = "Shannon", add_sig = TRUE)
t1 <- trans_alpha$new(dataset = dataset, group = "Type", by_group = "Group")
t1$cal_diff(method = "wilcox")
t1$plot_alpha(measure = "Shannon", add_sig = TRUE)
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-trans_alpha-new}{\code{trans_alpha$new()}}
\item \href{#method-trans_alpha-cal_diff}{\code{trans_alpha$cal_diff()}}
\item \href{#method-trans_alpha-plot_alpha}{\code{trans_alpha$plot_alpha()}}
\item \href{#method-trans_alpha-print}{\code{trans_alpha$print()}}
\item \href{#method-trans_alpha-clone}{\code{trans_alpha$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_alpha-new"></a>}}
\if{latex}{\out{\hypertarget{method-trans_alpha-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_alpha$new(
  dataset = NULL,
  group = NULL,
  by_group = NULL,
  by_ID = NULL,
  order_x = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{\code{\link{microtable}} object.}

\item{\code{group}}{default NULL; a column name of \code{sample_table} in the input microtable object used for the statistics across groups.}

\item{\code{by_group}}{default NULL; a column name of \code{sample_table} used to perform the differential test 
among groups (from \code{group} parameter) for each group (from \code{by_group} parameter) separately.}

\item{\code{by_ID}}{default NULL; a column name of \code{sample_table} used to perform paired T test or paired Wilcoxon test for the paired data,
such as continuous sampling of individual animals or plant compartments for different plant species (ID). 
So \code{by_ID} in sample_table should be the smallest unit of sample collection without any repetition in it.
When the \code{by_ID} parameter is provided, the function can automatically perform paired test, and no more parameters is required.}

\item{\code{order_x}}{default NULL; a column name of \code{sample_table} or a vector with sample names. If provided, sort samples using \code{factor}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{data_alpha} and \code{data_stat} stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
data(dataset)
t1 <- trans_alpha$new(dataset = dataset, group = "Group")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_alpha-cal_diff"></a>}}
\if{latex}{\out{\hypertarget{method-trans_alpha-cal_diff}{}}}
\subsection{Method \code{cal_diff()}}{
Differential test on alpha diversity.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_alpha$cal_diff(
  measure = NULL,
  method = c("KW", "KW_dunn", "wilcox", "t.test", "anova", "scheirerRayHare", "lm",
    "lme", "betareg", "glmm", "glmm_beta")[1],
  formula = NULL,
  p_adjust_method = "fdr",
  KW_dunn_letter = TRUE,
  alpha = 0.05,
  anova_post_test = "duncan.test",
  anova_varequal_test = FALSE,
  return_model = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measure}}{default NULL; character vector; If NULL, all indexes will be used; see names of \code{microtable$alpha_diversity}, 
e.g. \code{c("Observed", "Chao1", "Shannon")}.}

\item{\code{method}}{default "KW"; see the following available options:
\describe{
  \item{\strong{'KW'}}{Kruskal-Wallis Rank Sum Test for all groups (>= 2)}
  \item{\strong{'KW_dunn'}}{Dunn's Kruskal-Wallis Multiple Comparisons <10.1080/00401706.1964.10490181> based on \code{dunnTest} function in \code{FSA} package}
  \item{\strong{'wilcox'}}{Wilcoxon Rank Sum Test for all paired groups
        When \code{by_ID} parameter is provided in creating the object of the class, paired Wilcoxon test will be performed.}
  \item{\strong{'t.test'}}{Student's t-Test for all paired groups. 
        When \code{by_ID} parameter is provided in creating the object of the class, paired t-test will be performed.}
  \item{\strong{'anova'}}{Variance analysis. For one-way anova, the default post hoc test is Duncan's new multiple range test.
        Please use \code{anova_post_test} parameter to change the post hoc method.
        For multi-way anova, Please use \code{formula} parameter to specify the model and see \code{\link{aov}} for more details}
  \item{\strong{'scheirerRayHare'}}{Scheirer-Ray-Hare test (nonparametric test) for a two-way factorial experiment; 
        see \code{scheirerRayHare} function of \code{rcompanion} package}
  \item{\strong{'lm'}}{Linear Model based on the \code{lm} function}
  \item{\strong{'lme'}}{Linear Mixed Effect Model based on the \code{lmerTest} package}
  \item{\strong{'betareg'}}{Beta Regression for Rates and Proportions based on the \code{betareg} package}
  \item{\strong{'glmm'}}{Generalized linear mixed model (GLMM) based on the \code{glmmTMB} package.
        A family function can be provided using parameter passing, such as: \code{family = glmmTMB::lognormal(link = "log")}}
  \item{\strong{'glmm_beta'}}{Generalized linear mixed model (GLMM) with a family function of beta distribution. 
        This is an extension of the GLMM model in \code{'glmm'} option. 
        The only difference is in \code{glmm_beta} the family function is fixed with the beta distribution function, 
        facilitating the fitting for proportional data (ranging from 0 to 1). The link function is fixed with \code{"logit"}.}
}}

\item{\code{formula}}{default NULL; applied to two-way or multi-factor analysis when 
method is \code{"anova"}, \code{"scheirerRayHare"}, \code{"lm"}, \code{"lme"}, \code{"betareg"} or \code{"glmm"}; 
specified set for independent variables, i.e. the latter part of a general formula, 
such as \code{'block + N*P*K'}.}

\item{\code{p_adjust_method}}{default "fdr" (for "KW", "wilcox", "t.test" methods) or "holm" (for "KW_dunn"); P value adjustment method; 
For \code{method = 'KW', 'wilcox' or 't.test'}, please see \code{method} parameter of \code{p.adjust} function for available options;
For \code{method = 'KW_dunn'}, please see \code{dunn.test::p.adjustment.methods} for available options.}

\item{\code{KW_dunn_letter}}{default TRUE; For \code{method = 'KW_dunn'}, \code{TRUE} denotes significances are presented by letters;
\code{FALSE} means significances are shown by asterisk for paired comparison.}

\item{\code{alpha}}{default 0.05; Significant level; used for generating significance letters when method is 'anova' or 'KW_dunn'.}

\item{\code{anova_post_test}}{default "duncan.test". The post hoc test method for one-way anova. 
The default option represents the Duncan's new multiple range test.
Other available options include "LSD.test" (LSD post hoc test) and "HSD.test" (HSD post hoc test). 
All those are the function names from \code{agricolae} package.}

\item{\code{anova_varequal_test}}{default FALSE; whether conduct Levene's Test for equality of variances.
Only available for one-way anova. Significant P value means the variance among groups is not equal.}

\item{\code{return_model}}{default FALSE; whether return the original "lm", "lmer" or "glmm" model list in the object.}

\item{\code{...}}{parameters passed to \code{kruskal.test} (when \code{method = "KW"}) or \code{wilcox.test} function (when \code{method = "wilcox"}) or 
\code{dunnTest} function of \code{FSA} package (when \code{method = "KW_dunn"}) or 
\code{agricolae::duncan.test}/\code{agricolae::LSD.test}/\code{agricolae::HSD.test} (when \code{method = "anova"}, one-way anova) or 
\code{rcompanion::scheirerRayHare} (when \code{method = "scheirerRayHare"}) or 
\code{stats::lm} (when \code{method = "lm"}) or 
\code{lmerTest::lmer} (when \code{method = "lme"}) or 
\code{betareg::betareg} (when \code{method = "betareg"}) or 
\code{glmmTMB::glmmTMB} (when \code{method = "glmm"}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_diff}, stored in object with the format \code{data.frame}.\cr
    When method is "betareg", "lm", "lme" or "glmm", 
    "Estimate" and "Std.Error" columns represent the fitted coefficient and its standard error, respectively.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_diff(method = "KW")
t1$cal_diff(method = "anova")
t1 <- trans_alpha$new(dataset = dataset, group = "Type", by_group = "Group")
t1$cal_diff(method = "anova")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_alpha-plot_alpha"></a>}}
\if{latex}{\out{\hypertarget{method-trans_alpha-plot_alpha}{}}}
\subsection{Method \code{plot_alpha()}}{
Plot the alpha diversity. 
  Box plot (and others for visualizing data in groups of single factor) is used for the visualization of alpha diversity when the \code{group} is found in the object.
  When the formula is found in the \code{res_diff} table in the object, 
  heatmap is employed automatically to show the significances of differential test for multiple indexes, 
	 and errorbar (coefficient and standard errors) can be used for single index.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_alpha$plot_alpha(
  plot_type = "ggboxplot",
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  measure = "Shannon",
  group = NULL,
  add = NULL,
  add_sig = TRUE,
  add_sig_label = "Significance",
  add_sig_text_size = 3.88,
  add_sig_label_num_dec = 4,
  order_x_mean = FALSE,
  y_start = 0.1,
  y_increase = 0.05,
  xtext_angle = 30,
  xtext_size = 13,
  ytitle_size = 17,
  bar_width = 0.9,
  bar_alpha = 0.8,
  dodge_width = 0.9,
  plot_SE = TRUE,
  errorbar_size = 1,
  errorbar_width = 0.2,
  errorbar_addpoint = TRUE,
  errorbar_color_black = FALSE,
  point_size = 3,
  point_alpha = 0.8,
  add_line = FALSE,
  line_size = 0.8,
  line_type = 2,
  line_color = "grey50",
  line_alpha = 0.5,
  heatmap_cell = "P.unadj",
  heatmap_sig = "Significance",
  heatmap_x = "Factors",
  heatmap_y = "Measure",
  heatmap_lab_fill = "P value",
  coefplot_sig_pos = 2,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot_type}}{default "ggboxplot"; plot type; available options include "ggboxplot", "ggdotplot", "ggviolin", 
"ggstripchart", "ggerrorplot", "errorbar" and "barerrorbar".
The options starting with "gg" are function names coming from \code{ggpubr} package.
All those methods with \code{ggpubr} package use the \code{data_alpha} table in the object. 
"errorbar" represents Mean±SD or Mean±SE plot based on \code{ggplot2} package by invoking the \code{data_stat} table in the object.
"barerrorbar" denotes "bar plot + error bar". It is similar with "errorbar" and has a bar plot.}

\item{\code{color_values}}{default \code{RColorBrewer::brewer.pal}(8, "Dark2"); color pallete for groups.}

\item{\code{measure}}{default "Shannon"; one alpha diversity index in the object.}

\item{\code{group}}{default NULL; group name used for the plot.}

\item{\code{add}}{default NULL; add another plot element; passed to the \code{add} parameter of the function (e.g., \code{ggboxplot}) from \code{ggpubr} package 
when \code{plot_type} starts with "gg" (functions coming from ggpubr package).}

\item{\code{add_sig}}{default TRUE; whether add significance label using the result of \code{cal_diff} function, i.e. \code{object$res_diff};
This is manily designed to add post hoc test of anova or other significances to make the label mapping easy.}

\item{\code{add_sig_label}}{default "Significance"; select a colname of \code{object$res_diff} for the label text when 'Letter' is not in the table, 
such as 'P.adj' or 'Significance'.}

\item{\code{add_sig_text_size}}{default 3.88; the size of text in added label.}

\item{\code{add_sig_label_num_dec}}{default 4; reserved decimal places when the parameter \code{add_sig_label} use numeric column, like 'P.adj'.}

\item{\code{order_x_mean}}{default FALSE; whether order x axis by the means of groups from large to small.}

\item{\code{y_start}}{default 0.1; the y axis value from which to add the significance asterisk label; 
the default 0.1 means \code{max(values) + 0.1 * (max(values) - min(values))}.}

\item{\code{y_increase}}{default 0.05; the increasing y axia space to add the label (asterisk or letter); the default 0.05 means \code{0.05 * (max(values) - min(values))}; 
this parameter is also used to label the letters of anova result with the fixed space.}

\item{\code{xtext_angle}}{default 30; number (e.g. 30). Angle of text in x axis.}

\item{\code{xtext_size}}{default 13; x axis text size. NULL means the default size in ggplot2.}

\item{\code{ytitle_size}}{default 17; y axis title size.}

\item{\code{bar_width}}{default 0.9; the bar width when \code{plot_type = "barerrorbar"}.}

\item{\code{bar_alpha}}{default 0.8; the alpha of bar color when \code{plot_type = "barerrorbar"}.}

\item{\code{dodge_width}}{default 0.9; the dodge width used in \code{position_dodge} function of ggplot2 package when \code{plot_type} is "errorbar" or "barerrorbar".}

\item{\code{plot_SE}}{default TRUE; TRUE: the errorbar is \eqn{mean±se}; FALSE: the errorbar is \eqn{mean±sd}. Available when \code{plot_type} is "errorbar" or "barerrorbar".}

\item{\code{errorbar_size}}{default 1; errorbar size. Available when \code{plot_type} is "errorbar" or "barerrorbar".}

\item{\code{errorbar_width}}{default 0.2; errorbar width. Available when \code{plot_type} is "errorbar" or "barerrorbar" and \code{by_group} is NULL.}

\item{\code{errorbar_addpoint}}{default TRUE; whether add point for mean. Available when \code{plot_type} is "errorbar" or "barerrorbar" and \code{by_group} is NULL.}

\item{\code{errorbar_color_black}}{default FALSE; whether use black for the color of errorbar when \code{plot_type} is "errorbar" or "barerrorbar".}

\item{\code{point_size}}{default 3; point size for taxa. Available when \code{plot_type} is "errorbar" or "barerrorbar".}

\item{\code{point_alpha}}{default 0.8; point transparency. Available when \code{plot_type} is "errorbar" or "barerrorbar".}

\item{\code{add_line}}{default FALSE; whether add line. Available when \code{plot_type} is "errorbar" or "barerrorbar".}

\item{\code{line_size}}{default 0.8; line size when \code{add_line = TRUE}. Available when \code{plot_type} is "errorbar" or "barerrorbar".}

\item{\code{line_type}}{default 2; an integer; line type when \code{add_line = TRUE}. The available case is same with \code{line_size}.}

\item{\code{line_color}}{default "grey50"; line color when \code{add_line = TRUE}. Available when \code{by_group} is NULL. Other available case is same with \code{line_size}.}

\item{\code{line_alpha}}{default 0.5; line transparency when \code{add_line = TRUE}. The available case is same with \code{line_size}.}

\item{\code{heatmap_cell}}{default "P.unadj"; the column of \code{res_diff} table for the cell of heatmap when formula with multiple factors is found in the method.}

\item{\code{heatmap_sig}}{default "Significance"; the column of \code{res_diff} for the significance label of heatmap.}

\item{\code{heatmap_x}}{default "Factors"; the column of \code{res_diff} for the x axis of heatmap.}

\item{\code{heatmap_y}}{default "Taxa"; the column of \code{res_diff} for the y axis of heatmap.}

\item{\code{heatmap_lab_fill}}{default "P value"; legend title of heatmap.}

\item{\code{coefplot_sig_pos}}{default 2; Significance label position in the coefficient point and errorbar plot. 
The formula is \code{Estimate + coefplot_sig_pos * Std.Error}.
This plot is used when there is only one measure found in the table, 
and 'Estimate' and 'Std.Error' are both in the column names (such as for \code{lm} and \code{lme methods}).
The x axis is 'Estimate', and y axis denotes 'Factors'.
When coefplot_sig_pos is a negative value, the label is in the left of the errorbar.
Errorbar size and width in the coefficient point plot can be adjusted with the parameters \code{errorbar_size} and \code{errorbar_width}. 
Point size and alpha can be adjusted with parameters \code{point_size} and \code{point_alpha}. 
The significance label size can be adjusted with parameter \code{add_sig_text_size}.
Furthermore, the vertical line around 0 can be adjusted with parameters \code{line_size}, \code{line_type}, \code{line_color} and \code{line_alpha}.}

\item{\code{...}}{parameters passing to \code{ggpubr::ggboxplot} function (or other functions shown by \code{plot_type} parameter when it starts with "gg") or 
\code{plot_cor} function in \code{\link{trans_env}} class for the heatmap of multiple factors when formula is found in the \code{res_diff} of the object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1 <- trans_alpha$new(dataset = dataset, group = "Group")
t1$cal_diff(method = "wilcox")
t1$plot_alpha(measure = "Shannon", add_sig = TRUE)
t1 <- trans_alpha$new(dataset = dataset, group = "Type", by_group = "Group")
t1$cal_diff(method = "wilcox")
t1$plot_alpha(measure = "Shannon", add_sig = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_alpha-print"></a>}}
\if{latex}{\out{\hypertarget{method-trans_alpha-print}{}}}
\subsection{Method \code{print()}}{
Print the trans_alpha object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_alpha$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_alpha-clone"></a>}}
\if{latex}{\out{\hypertarget{method-trans_alpha-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_alpha$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
