% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genquantselect.R
\name{thselect.expgqt}
\alias{thselect.expgqt}
\title{Generalized quantile threshold selection}
\usage{
thselect.expgqt(
  xdat,
  maxiter = 10L,
  tol = 2,
  kmin = max(10, floor(length(xdat)/100)),
  kmax = floor(0.8 * length(xdat)),
  ...
)
}
\arguments{
\item{xdat}{[vector] sample of exceedances}

\item{maxiter}{[int] maximum number of iteration}

\item{tol}{[double] tolerance for difference in value of \eqn{k} for the fixed point}

\item{kmin}{[int] minimum number of exceedances for the estimator}

\item{kmax}{[int] maximum number of exceedances for the estimator}

\item{...}{additional arguments, currently ignored}
}
\value{
a list with components
\itemize{
\item \code{shape} the Hill estimator of the shape, based on the \code{k} largest order statistics
\item \code{k0} number of high order statistics for estimation of the shape using Hill's estimator
\item \code{rho} estimate of the second order regular variation parameter
\item \code{mse} mean squared error estimate of the shape parameter
\item \code{se} standard error of the shape parameter
\item \code{convergence} logical; if \code{TRUE}, indicates that the method converged to a fixed point within \code{tol} before reaching the maximum number of iterations \code{maxiter}
}
}
\description{
The methodology proposed by Beirlant, Vynckier and Teugels (1996)
uses an asymptotic expansion of the mean squared error for Hill's estimator given
a random sample with Pareto tails and positive shape, using an exponential regression.
The value of \code{k} is selected to minimize the mean squared error given optimal weighting scheme. This
depends on the order of regular variation \eqn{\rho}, which is obtained based on the slope of the difference
in Hill estimators, suitably reweighted. The iterative procedure of Beirlant et al. alternates between parameter estimation
until convergence. It returns the Hill shape estimate, the number of higher order statistic, the parameter \code{rho} and
estimates of the standard error of the shape and the mean squared error, based on the ultimate parameter values.
Since the weights can become negative, there is no guarantee that the mean squared error estimate is positive, nor that
the estimated value of \eqn{\rho} is nonpositive.
}
\examples{
# Simulate Pareto data - log(xdat) is exponential with rate 2
xdat <- rgp(n = 200, loc = 1, scale = 0.5, shape = 0.5)
(thselect.expgqt(xdat))
}
\references{
Beirlant, J., Vynckier, P., & Teugels, J. L. (1996). Excess Functions and Estimation of the Extreme-Value Index. \emph{Bernoulli}, 2(\bold{4}), 293–318. \doi{10.2307/3318416}
}
