% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est.mean.R
\name{est.gld.five}
\alias{est.gld.five}
\title{Estimating Unknown Parameters using Five-Number Summary}
\usage{
est.gld.five(
   min = NULL, 
   q1 = NULL, 
   med = NULL, 
   q3 = NULL, 
   max = NULL, 
   n = NULL, 
   opt = TRUE
   )
}
\arguments{
\item{min}{numeric value representing the sample minimum.}

\item{q1}{numeric value representing the first quartile of the sample.}

\item{med}{numeric value representing the median of the sample.}

\item{q3}{numeric value representing the third quartile of the sample.}

\item{max}{numeric value representing the sample maximum.}

\item{n}{numeric value specifying the sample size.}

\item{opt}{logical value indicating whether to apply the optimisation step in estimating parameters using theoretical quantiles.
The default value is \code{TRUE}.}
}
\value{
A list with following components:
\itemize{
\item \code{parameters}: named numeric vector representing the estimated parameters ('location', 'inverse scale', 'shape 1', 'shape 2') of GLD .
\item \code{mean}: numeric value of the estimated mean of the sample using GLD.
\item \code{sd}: numeric value of the estimated standard deviation of the sample using GLD.
}
}
\description{
This function provide estimates for the parameters of generalised lambda distribution (GLD), the sample mean and the standard deviation using 5-number summary \{minimum, first quartile, median, third quartile, maximum\} from a study with sample size \eqn{n},
using the method explained in De Livera et al. (2024).
}
\details{
De Livera et al. (2024) proposed using the generalised lambda distribution (GLD) to estimate unknown parameters for studies reporting 5-number summaries in the meta-analysis context.

The GLD is a four parameter family of distributions defined by its quantile function under the FKML parameterisation (Freimer et al., 1988).
De Livera et al. propose that the GLD quantlie function can be used to approximate a sample's distribution using 5-point summaries.
The four parameters of GLD quantile function include: a location parameter (\eqn{\lambda_1}), an inverse scale parameter (\eqn{\lambda_2}>0), and two shape parameters (\eqn{\lambda_3} and \eqn{\lambda_4}).
The parameters of the GLD are estimated by formulating and solving a set of simultaneous equations which relate the estimated sample quantiles to their theoretical counterparts of the GLD.
}
\examples{
#Generate 5-number summary data
set.seed(123)
n <- 1000
x <- stats::rlnorm(n, 4, 0.3)
quants <- c(min(x), stats::quantile(x, probs = c(0.25, 0.5, 0.75)), max(x))

#Estimate GLD parameters using 5-number summary
params<- est.gld.five(min = quants[1], q1 = quants[2], med = quants[3], q3 = quants[4], 
                          max = quants[5], n=n, opt=TRUE)$parameters
params

}
\references{
De Livera, A. M., Prendergast, L., & Kumaranathunga, U. (2024). A novel density-based approach for estimating unknown means, distribution visualisations and meta-analyses of quantiles. \emph{arXiv preprint arXiv:2411.10971}. \url{https://arxiv.org/abs/2411.10971}.

Freimer, M., Kollia, G., Mudholkar, G. S., & Lin, C. T. (1988). A study of the generalized Tukey lambda family. \emph{Communications in Statistics—Theory and Methods, 17}(10), 3547–3567.

Gilchrist, W. (2000). \emph{Statistical modelling with quantile functions}. Chapman & Hall/CRC.

King, R., Dean, B., Klinke, S., & van Staden, P. (2025). gld: Estimation and use of the Generalised (Tukey) Lambda Distribution (R package Version 2.6.7). Comprehensive R Archive Network (CRAN). https://doi.org/10.32614/CRAN.package.gld. \url{https://CRAN.R-project.org/package=gld}.
}
\seealso{
\code{\link[=est.sld.minq2max]{est.sld.minq2max()}}, \code{\link[=est.sld.q1q2q3]{est.sld.q1q2q3()}}
}
