% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SFL.Algorithm.R
\name{SFL}
\alias{SFL}
\title{Optimization using Shuffled Frog Leaping Algorithm}
\usage{
SFL(FUN, optimType = "MIN", numVar, numPopulation = 40,
  maxIter = 500, rangeVar, numMemeplex = as.integer(numPopulation/3),
  frogLeapingIteration = as.integer(10))
}
\arguments{
\item{FUN}{an objective function or cost function,}

\item{optimType}{a string value that represent the type of optimization.
There are two option for this arguments: \code{"MIN"} and \code{"MAX"}.
The default value is \code{"MIN"}, which the function will do minimization.
Otherwise, you can use \code{"MAX"} for maximization problem.
The default value is \code{"MIN"}.}

\item{numVar}{a positive integer to determine the number variables.}

\item{numPopulation}{a positive integer to determine the number populations. The default value is 40.}

\item{maxIter}{a positive integer to determine the maximum number of iterations. The default value is 500.}

\item{rangeVar}{a matrix (\eqn{2 \times n}) containing the range of variables,
where \eqn{n} is the number of variables, and first and second rows
are the lower bound (minimum) and upper bound (maximum) values, respectively.
If all variable have equal upper bound, you can define \code{rangeVar} as
matrix (\eqn{2 \times 1}).}

\item{numMemeplex}{a positive integer (as.integer()) between 0 and numVar to
determine number of memeplexes (see details). The default value is \code{as.integer(numPopulation/3)}.}

\item{frogLeapingIteration}{a positive integer (as.integer()) to determine number
of iterations for each memeplex. The default value is \code{as.integer(10)}.}
}
\value{
\code{Vector [v1, v2, ..., vn]} where \code{n} is number variable
        and \code{vn} is value of \code{n-th} variable.
}
\description{
This is the internal function that implements Shuffled Frog Leaping
Algorithm. It is used to solve continuous optimization tasks.
Users do not need to call it directly,
but just use \code{\link{metaOpt}}.
}
\details{
This algorithm was proposed by (Eusuff, Lansey & Pasha, 2006).
The main inspiration for SFL algorithm originates from how swarm of frogs
finding foods.

In order to find the optimal solution, the algorithm follow the following steps.
\itemize{
\item initialize population randomly.
\item separate population into "numMemeplex" memeplexes.
\item update worst candidate solution using best candidate solution on
      each memeplex as much as "frogLeaping Iteration".
\item Shuffled back each memeplexes into population.
\item Sort population based on fitness.
\item If a termination criterion (a maximum number of iterations or a sufficiently good fitness) is met,
      exit the loop, else back to separate population into memeplexes.
}
}
\examples{
##################################
## Optimizing the quartic with noise function

# define Quartic with noise function as objective function
quartic <- function(x){
    dim <- length(x)
    result <- sum(c(1:dim)*(x^4))+runif(1)
    return(result)
}

## Define parameter
numVar <- 5
rangeVar <- matrix(c(-1.28, 1.28), nrow=2)

## calculate the optimum solution shuffled frog leaping algorithm
resultSFL <- SFL(quartic, optimType="MIN", numVar, numPopulation=20,
                 maxIter=100, rangeVar)

## calculate the optimum value using quartic with noise function
optimum.value <- quartic(resultSFL)

}
\references{
Eusuff, M., Lansey, K., & Pasha, F. (2006). Shuffled frog-leaping algorithm:
a memetic meta-heuristic for discrete optimization. Engineering Optimization,
38(2), 129–154.
}
\seealso{
\code{\link{metaOpt}}
}
