% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knowledge_weights.R
\name{knowledge_weights}
\alias{knowledge_weights}
\title{Calculate the Weights that Minimize the Knowledge Gap}
\usage{
knowledge_weights(E, P)
}
\arguments{
\item{E}{Vector of \eqn{J \ge 5} estimates of the outcome.}

\item{P}{Vector of \eqn{J \ge 5} predictions of others. The values must be in the same order as the estimates in \code{E}.
Specifically, for all \eqn{j = 1, ..., J}, \code{E[j]} and \code{P[j]} give the \eqn{j}th judge's estimate and prediction of others, respectively.}
}
\value{
\eqn{Jx1} vector of weights that minimizes the knowledge gap and lead to the knowledge-weighted estimate.
}
\description{
This function computes the weighted used in the knowledge-weighted estimate of \emph{Palley & Satopää (2021):
Boosting the Wisdom of Crowds Within a Single Judgment Problem: Weighted Averaging Based on Peer Predictions}.
The current version of the paper is available at \url{https://papers.ssrn.com/sol3/Papers.cfm?abstract_id=3504286}
}
\examples{
# Illustration on the Three Gorges Dam Example in Palley & Satopää (2021):

# Judges' estimates:
E = c(50, 134, 206, 290, 326, 374)
# Judges' predictions of others
P = c(26, 92, 116, 218, 218, 206)

# Weights used in the knowledge-weighted estimate:
alpha = knowledge_weights(E,P)

# Knowledge-weighted estimate is 329.3266
t(alpha) \%*\% E

# Alternatively, the knowledge-weighted estimate can be calculated using 
# the knowledge_weighted_estimate() function. This returns 329.305, which
# is slightly different from the above result. The difference arises because
# knowledge_weighted_estimate() improves stability by standardizing the 
# judges' responses before aggregating them.
knowledge_weighted_estimate(E,P)
}
