% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ismember.R
\name{ismember}
\alias{ismember}
\alias{ismember,data.frame,data.frame-method}
\title{Array elements that are members of set array}
\usage{
ismember(A, B, rows = FALSE, indices = FALSE)

\S4method{ismember}{data.frame,data.frame}(A, B, rows = FALSE, indices = FALSE)
}
\arguments{
\item{A}{a vector, matrix or dataframe}

\item{B}{another vector, matrix or dataframe}

\item{rows}{if \code{TRUE}, each row of A and each row of B are treated as
single entities}

\item{indices}{if \code{TRUE}, outputs the lowest B index for each match in A}
}
\value{
a binary vector telling if the corresponding A indices are in B. If
\code{indices = TRUE}, also prints the index in B where the match first
occurs.
}
\description{
Checks which members of one entity are in another
}
\examples{
# Values that are members of set
A <- c(5, 3, 4, 2)
B <- c(2, 4, 4, 4, 6, 8)
ismember(A, B)

# Members of set and indices to values
ismember(A, B, indices = TRUE)

# Table rows found in another table
A <- data.frame(
 "V1" = 1:5, "V2" = LETTERS[1:5], "V3" = as.logical(c(0, 1, 0, 1, 0))
)
B <- data.frame(
 "V1" = seq(1, 9, 2), "V2" = LETTERS[seq(1, 9, 2)], "V3" = as.logical(rep(0, 5))
)
ismember(A, B)

}
\author{
Waldir Leoncio
}
