% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markdownInput.R
\name{moduleMarkdownInput}
\alias{moduleMarkdownInput}
\title{Server function of the \code{markdownInput} module}
\usage{
moduleMarkdownInput(input, output, session, class = "")
}
\arguments{
\item{input}{The session's input object.}

\item{output}{The session's output object.}

\item{session}{The shiny's session.}

\item{class}{(optional) The CSS class name of the priview tab.}
}
\value{
The reactive value of the input.
}
\description{
Server function of the \code{markdownInput} module
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {
 library(shiny)
 library(markdownInput)
 ui <- fluidPage(titlePanel("Markdown input"),
                 sidebarLayout(
                   # inputs:
                   sidebarPanel(
                     markdownInput(
                       "mdInputID",
                       label = "Write your text",
                       value = "Write some _markdown_ **here:**"
                       )
                   ),

                   # outputs:
                   mainPanel(
                   h3("Raw value of the input:"),
                   verbatimTextOutput("rawResult"))
                 ))

 server <- function(input, output, session) {
   # myText is a reactive variable containing the raw markdown text
   myText <- callModule(moduleMarkdownInput, "mdInputID")

   # show "myText"
   output$rawResult <- renderPrint({
     print(myText())
   })

 }

 shinyApp(ui, server)

}
}
\references{
\enumerate{
\item{\href{https://CRAN.R-project.org/package=shinyAce}{shinyAce} package:
}{Vincent Nijs, Forest Fang, Trestle Technology, LLC and Jeff Allen (2019).
shinyAce: Ace Editor Bindings for Shiny.}

\item{\href{https://CRAN.R-project.org/package=shiny}{shiny} package: }{
Winston Chang, Joe Cheng, JJ Allaire, Yihui Xie and Jonathan McPherson
(2018). shiny: Web Application Framework for R.}

\item{\href{https://CRAN.R-project.org/package=markdown}{markdown} package:
}{ JJ Allaire, Jeffrey Horner, Yihui Xie, Vicent Marti and Natacha Porte
(2018). markdown: 'Markdown' Rendering for R.} }
}
\author{
Julien Diot \email{juliendiot42@gmail.com}
}
