% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_ph.R
\name{rphase}
\alias{rphase}
\title{Sampling of PH distributions}
\usage{
rphase(n, ph, ...)
}
\arguments{
\item{n}{An integer of the number of samples.}

\item{ph}{An instance of PH distribution.}

\item{...}{Others}
}
\value{
A vector of samples.
}
\description{
Generate a sample from a given PH distribution.
}
\examples{
## create a PH with specific parameters
(phdist <- ph(alpha=c(1,0,0),
              Q=rbind(c(-4,2,0),c(2,-5,1),c(1,0,-1)),
              xi=c(2,2,0)))

## generate 10 samples
rphase(n=10, ph=phdist)

}
