% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phfit.R
\name{phfit.point}
\alias{phfit.point}
\title{PH fitting with point data}
\usage{
phfit.point(ph, x, weights, ...)
}
\arguments{
\item{ph}{An object of R6 class for PH. The estimation algorithm is selected depending on this class.}

\item{x}{A vector for point data.}

\item{weights}{A vector of weights for points.}

\item{...}{Further options for fitting methods.}
}
\value{
Returns a list with components, which is an object of S3 class \code{phfit.result};
\item{model}{an object for estimated PH class.}
\item{llf}{a value of the maximum log-likelihood.}
\item{df}{a value of degrees of freedom of the model.}
\item{aic}{a value of Akaike information criterion.}
\item{iter}{the number of iterations.}
\item{convergence}{a logical value for the convergence of estimation algorithm.}
\item{ctime}{computation time (user time).}
\item{data}{an object for data class}
\item{aerror}{a value of absolute error for llf at the last step of algorithm.}
\item{rerror}{a value of relative error for llf at the last step of algorithm.}
\item{options}{a list of options used for fitting.}
\item{call}{the matched call.}
}
\description{
Estimates PH parameters from point data.
}
\examples{
## make sample
wsample <- rweibull(n=100, shape=2, scale=1)

## PH fitting for general PH
(result1 <- phfit.point(ph=ph(2), x=wsample))

## PH fitting for CF1
(result2 <- phfit.point(ph=cf1(2), x=wsample))

## PH fitting for hyper Erlang
(result3 <- phfit.point(ph=herlang(3), x=wsample))

## mean
ph.mean(result1$model)
ph.mean(result2$model)
ph.mean(result3$model)

## variance
ph.var(result1$model)
ph.var(result2$model)
ph.var(result3$model)

## up to 5 moments 
ph.moment(5, result1$model)
ph.moment(5, result2$model)
ph.moment(5, result3$model)

}
