% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-auc.R
\name{luz_metric_binary_auroc}
\alias{luz_metric_binary_auroc}
\title{Computes the area under the ROC}
\usage{
luz_metric_binary_auroc(
  num_thresholds = 200,
  thresholds = NULL,
  from_logits = FALSE
)
}
\arguments{
\item{num_thresholds}{Number of thresholds used to compute confusion matrices.
In that case, thresholds are created by getting \code{num_thresholds} values linearly
spaced in the unit interval.}

\item{thresholds}{(optional) If threshold are passed, then those are used to compute the
confusion matrices and \code{num_thresholds} is ignored.}

\item{from_logits}{Boolean indicating if predictions are logits, in that case
we use sigmoid to put them in the unit interval.}
}
\description{
To avoid storing all predictions and targets for an epoch we compute confusion
matrices across a range of pre-established thresholds.
}
\examples{
if (torch::torch_is_installed()){
library(torch)
actual <- c(1, 1, 1, 0, 0, 0)
predicted <- c(0.9, 0.8, 0.4, 0.5, 0.3, 0.2)

y_true <- torch_tensor(actual)
y_pred <- torch_tensor(predicted)

m <- luz_metric_binary_auroc(thresholds = predicted)
m <- m$new()

m$update(y_pred[1:2], y_true[1:2])
m$update(y_pred[3:4], y_true[3:4])
m$update(y_pred[5:6], y_true[5:6])

m$compute()
}
}
\seealso{
Other luz_metrics: 
\code{\link{luz_metric}()},
\code{\link{luz_metric_accuracy}()},
\code{\link{luz_metric_binary_accuracy}()},
\code{\link{luz_metric_binary_accuracy_with_logits}()},
\code{\link{luz_metric_mae}()},
\code{\link{luz_metric_mse}()},
\code{\link{luz_metric_multiclass_auroc}()},
\code{\link{luz_metric_rmse}()}
}
\concept{luz_metrics}
