# lightsf - Collection of georeferenced and spatial datasets from different domains
# Version 0.1.0
# Copyright (C) 2025 Ingrid Romero Pinilla
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# dc_poly

library(testthat)

# Test 1: Confirm the object is an sf, tibble, and data.frame
test_that("dc_poly is an sf, tibble, and data.frame", {
  expect_s3_class(dc_poly, "sf")
  expect_s3_class(dc_poly, "tbl_df")
  expect_s3_class(dc_poly, "data.frame")
})

# Test 2: Confirm it has exactly 5 columns
test_that("dc_poly has 5 columns", {
  expect_equal(length(dc_poly), 5)
})

# Test 3: Confirm it has exactly 206 rows
test_that("dc_poly has 206 rows", {
  expect_equal(nrow(dc_poly), 206)
})

# Test 4: Confirm column names are correct
test_that("dc_poly has correct column names", {
  expect_named(dc_poly, c("GEOID", "NAME", "geometry", "B01003_001", "B19013_001"))
})

# Test 5: Confirm column types are as expected
test_that("dc_poly columns have correct types", {
  expect_type(dc_poly$GEOID, "character")
  expect_type(dc_poly$NAME, "character")
  expect_s3_class(dc_poly$geometry, "sfc_POLYGON")
  expect_type(dc_poly$B01003_001, "double")
  expect_type(dc_poly$B19013_001, "double")
})
