% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlatedLHS.R
\name{correlatedLHS}
\alias{correlatedLHS}
\title{Transformed Latin hypercube with a multivariate distribution}
\usage{
correlatedLHS(
  lhs,
  marginal_transform_function,
  cost_function,
  debug = FALSE,
  maxiter = 10000,
  ...
)
}
\arguments{
\item{lhs}{a Latin hypercube sample that is uniformly distributed on the
margins}

\item{marginal_transform_function}{a function that takes Latin hypercube sample
as the first argument and other passed-through variables as desired.  \code{...} must
be passed as a argument.  For example, \code{f <- function(W, second_argument, ...)}.
Must return a \code{matrix} or \code{data.frame}}

\item{cost_function}{a function that takes a transformed Latin hypercube sample
as the first argument and other passed-through variables as desired.    \code{...} must
be passed as a argument.  For example, \code{f <- function(W, second_argument, ...)}}

\item{debug}{Should debug messages be printed.  Causes cost function output
and iterations to be printed to aid in setting the maximum number of iterations}

\item{maxiter}{the maximum number of iterations.  The algorithm proceeds by
swapping one variable of two points at a time.  Each swap is an iteration.}

\item{...}{Additional arguments to be passed through to the \code{marginal_transform_function}
and \code{cost_function}}
}
\value{
a list of the Latin hypercube with uniform margins, the transformed
Latin hypercube, and the final cost
}
\description{
A method to create a transformed Latin Hypercube sample where the marginal
distributions can be correlated according to an arbitrary set of criteria
contained in a minimized cost function
}
\examples{
correlatedLHS(lhs::randomLHS(30, 2),
  marginal_transform_function = function(W, ...) {
    W[,1] <- qnorm(W[,1], 1, 3)
    W[,2] <- qexp(W[,2], 2)
    return(W)
  },
  cost_function = function(W, ...) {
    (cor(W[,1], W[,2]) - 0.5)^2
  },
  debug = FALSE,
  maxiter = 1000)
}
