% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main-datautil.R
\name{add_dis_age}
\alias{add_dis_age}
\title{Easily add the disease-related age variable to a data frame}
\usage{
add_dis_age(data, t_init, id_var = "id", time_var = "age")
}
\arguments{
\item{data}{the original data frame}

\item{t_init}{A named vector containing the observed initiation or onset
time for each individual. The names, i.e. \code{names(t_init)}, should
specify the individual id.}

\item{id_var}{name of the id variable in \code{data}}

\item{time_var}{name of the time variable in \code{data}}
}
\value{
A data frame with one column added. The new column will
be called \code{dis_age}. For controls, its value will be \code{NaN}.
}
\description{
Creates the disease-related age covariate vector based on the
disease initiation times and adds it to the data frame
}
\seealso{
Other data frame handling functions: 
\code{\link{add_factor}()},
\code{\link{add_factor_crossing}()},
\code{\link{adjusted_c_hat}()},
\code{\link{new_x}()},
\code{\link{split}()}
}
\concept{data frame handling functions}
