% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpOptimizationInternal.R
\name{.gpOptimizationInternal}
\alias{.gpOptimizationInternal}
\title{.gpOptimizationInternal}
\usage{
.gpOptimizationInternal(
  par,
  weights,
  fn,
  gr = NULL,
  additionalArguments,
  isCpp = FALSE,
  penalty,
  tuningParameters,
  method,
  control
)
}
\arguments{
\item{par}{labeled vector with starting values}

\item{weights}{labeled vector with weights for each of the parameters in the
model.}

\item{fn}{R function which takes the parameters AND their labels
as input and returns the fit value (a single value)}

\item{gr}{R function which takes the parameters AND their labels
as input and returns the gradients of the objective function.
If set to NULL, numDeriv will be used to approximate the gradients}

\item{additionalArguments}{additional argument passed to fn and gr}

\item{isCpp}{boolean: are fn and gr C++ function pointers?}

\item{penalty}{string: name of the penalty used in the model}

\item{tuningParameters}{data.frame with tuning parameter values}

\item{method}{which optimizer should be used? Currently implemented are ista
and glmnet. With ista, the control argument can be used to switch to related procedures
(currently gist).}

\item{control}{used to control the optimizer. This element is generated with
the controlIsta() and controlGlmnet() functions.}
}
\value{
Object of class gpRegularized
}
\description{
Internal function: This function computes the regularized models
for all penaltiy functions which are implemented for glmnet and gist.
Use the dedicated penalty functions (e.g., lessSEM::gpLasso) to penalize
the model.
}
\keyword{internal}
