% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LBI.R
\name{LBI}
\alias{LBI}
\title{LBI}
\usage{
LBI(
  study_area_id,
  study_area_polygon,
  nobs = 250,
  nboot = 1000,
  fact_location = 10,
  elevation = NULL,
  raw_output = FALSE
)
}
\arguments{
\item{study_area_id}{Character string. Name ID of the study case area or
country name.}

\item{study_area_polygon}{Polygon shapefile. It should be a sfc object, of
class POLYGON or MULTIPOLYGON.}

\item{nobs}{Numeric. Number of random observations in each sample. 250 by
default.}

\item{nboot}{Numeric. Determines how many times the random shifts are
calculated. 1,000 by default.}

\item{fact_location}{Numeric. fact_location x nobs determine all the
possible coordinates that can be sampled within the provided polygon for all
bootstraps (faster than to generate a set of random location at each
bootstrap)}

\item{elevation}{Elevation raster. elevation in wgs84; if not provided,
NA will be returned for null-model elevational shifts.}

\item{raw_output}{Logical. FALSE by default. If TRUE, all bootstraps
are returned as a data.frame. => say that the raw outputs are accessible}
}
\value{
A data.frame or a list of two data.frames if raw_output is set to TRUE.
}
\description{
Computes the Latitudinal Bias Index (LBI) for a given shapefile, by
calculating the distance between two random locations within the shape
multiple times (see details).
}
\details{
The main output contains the following columns:
\itemize{
\item study_area_id: ID or name of the study case region
\item distance_km: average expected geographic distance shift between t1 and
t2
\item null_mod_SN_shift: average expected South-North shift between t1 and t2,
in absolute values
\item null_mod_EW_shift: average expected East-West shift between t1 and t2,
in absolute values
\item null_mod_elevation_shift: average expected elevation shift between t1 and
t2, in absolute values
\item LBI: the Latitudinal Bias Index value
}

LBI formula is

\eqn{LBI = 2\times(\frac{mean(|\frac{A_nlat}{A_nlon}|)}{1+mean(|\frac{A_nlat}{A_nlon}|)}-0.5)}

with \eqn{A_nlat} and \eqn{A_nlon} denoting the geographic displacement of
the centroid positions of both sets of observation in the nth iteration by
means in the latitudinal and the longitudinal dimension.
}
\examples{
\donttest{
study_area <- rnaturalearth::ne_countries(scale = 110, continent = "Europe",
country = "Sweden", type = "map_units", returnclass = "sf")
study_area <- sf::st_union(study_area)

LBI(study_area_id = "Sweden", study_area_polygon = study_area,
nobs = 10, nboot = 10, fact_location = 5, elevation = NULL)

# With elevation
elevation_df <- elevatr::get_elev_raster(
locations = sf::st_as_sf(study_area), z = 5)
LBI(study_area_id = "Sweden", study_area_polygon = study_area,
nobs = 10, nboot = 10, fact_location = 5, elevation = elevation_df)
}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Sanczuk et al. submitted.
}\if{html}{\out{</div>}}
}
