% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/require.R
\name{require_module}
\alias{require_module}
\title{Require a Python module}
\usage{
require_module(
  module,
  options = NULL,
  version = NULL,
  source = NULL,
  python_version = NULL,
  silent = FALSE
)
}
\arguments{
\item{module}{The name of the Python module to require}

\item{options}{A vector of defined optional dependencies for the module that
is being required}

\item{version}{A string specifying the version of the module to require}

\item{source}{A source for the module requirement, for example
\verb{git+https://github.com/owner/module.git}}

\item{python_version}{A string defining the Python version to require. Passed
to \code{\link[reticulate:py_require]{reticulate::py_require()}}}

\item{silent}{Whether to suppress the message showing what has been required}
}
\value{
The result of \link[reticulate:py_require]{reticulate::py_require}
}
\description{
This function can be used to require that Python modules are available for
\pkg{laminr}  with additional checks and nicer error messages.
}
\details{
Python dependencies are set using \code{\link[reticulate:py_require]{reticulate::py_require()}}. If a connection
to Python is already initialized and the requested module is already in the
list of requirements then a further call to \code{\link[reticulate:py_require]{reticulate::py_require()}} will
not be made to avoid errors/warnings. This means that required versions etc.
need to be set before Python is initialized.
\subsection{Arguments}{
\itemize{
\item Setting \code{options = c("opt1", "opt2")} results in \code{"module[opt1,opt2]"}
\item Setting \code{version = ">=1.0.0"} results in \code{"module>=1.0.0"}
\item Setting \code{source = "my_source"} results in \code{"module @ my_source"}
\item Setting all of the above results in \code{"module[opt1,opt2]>=1.0.0 @ my_source"}
}
}
}
\examples{
\dontrun{
# Require lamindb
require_module("lamindb")

# Require a specific version of lamindb
require_module("lamindb", version = ">=1.2")

# Require require lamindb with options
require_module("lamindb", options = c("bionty", "wetlab"))

# Require the development version of lamindb from GitHub
require_module("lamindb", source = "git+https://github.com/laminlabs/lamindb.git")

# Require lamindb with a specific Python version
require_module("lamindb", python_version = "3.12")
}
}
\seealso{
\code{\link[reticulate:py_require]{reticulate::py_require()}}
}
