% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{as_igraph}
\alias{as_igraph}
\title{Convert a Kuzu Query Result to an igraph Object}
\usage{
as_igraph(query_result)
}
\arguments{
\item{query_result}{A \code{kuzu_query_result} object from \code{kuzu_execute()} that
contains a graph.}
}
\value{
An \code{igraph} object.
}
\description{
Converts a Kuzu query result into an \code{igraph} graph object.
}
\details{
This function takes a \code{kuzu_query_result} object, converts it to a
\code{networkx} graph in Python, extracts the nodes and edges into R data frames,
and then constructs an \code{igraph} object. It is the final step in the
\code{kuzu_execute -> as_igraph} workflow.
}
\examples{
\donttest{
if (requireNamespace("igraph", quietly = TRUE)) {
  conn <- kuzu_connection(":memory:")
  kuzu_execute(conn, "CREATE NODE TABLE Person(name STRING, 
  PRIMARY KEY (name))")
  kuzu_execute(conn, "CREATE REL TABLE Knows(FROM Person TO Person)")
  kuzu_execute(conn, "CREATE (p:Person {name: 'Alice'}), 
  (q:Person {name: 'Bob'})")
  kuzu_execute(conn, "MATCH (a:Person), (b:Person) WHERE
                                                    a.name='Alice' AND 
                                                    b.name='Bob'
                                                    CREATE (a)-[:Knows]->(b)"
)

  res <- kuzu_execute(conn, "MATCH (p:Person)-[k:Knows]->(q:Person) 
  RETURN p, k, q")
  g <- as_igraph(res)
  print(g)
  rm(conn, res, g)
}
}
}
