% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lik_clo}
\alias{lik_clo}
\title{Compute the log likelihood for an inverse gamma stochastic volatility model}
\usage{
lik_clo( Res,  b2,  n, rho,  NIT=200,  niter=200,  nproc=2,  nproc2=2)
}
\arguments{
\item{Res}{Matrix of OLS residuals. Usually resulting from a call to priorvar.}

\item{b2}{Level of volatility.}

\item{n}{Degrees of freedom.}

\item{rho}{The parameter for the persistence of volatility.}

\item{NIT}{The degree of approximation to truncate the log likelihood sum. The default value is set at 200.}

\item{niter}{The degree of approximation to truncate the hypergeometric sum. The default value is set at 200.}

\item{nproc}{The number of processors allocated to evaluating the hypergeometric function. The default value is set at 2.}

\item{nproc2}{The number of processors allocated to computing the log likelihood. The default value is set at 2.}
}
\value{
A list of 7 items. List item number 1, is the sum of the log likelihood, while the rest are constants that are useful to obtain the smoothed estimates of the volatility.
}
\description{
Computes the log likelihood for an inverse gamma stochastic volatility model using a closed form expression of the likelihood. The details of the computation of this closed form expression are given in Leon-Gonzalez, R., & Majoni, B. (2023). Exact Likelihood for Inverse Gamma Stochastic Volatility Models (No. 23-11). Computations in 'MAC OS' are single-threaded if 'OpenMP' is not installed.
}
\details{
The closed form expression is obtained for the log likelihood of a stationary inverse gamma stochastic volatility model by marginalising out the volatilities. This allows the user to obtain the maximum likelihood estimator for this non linear non Gaussian state space model. When combined with \code{DrawK0}, the function can in addition obtain the estimates of the smoothed volatilities using the exact smoothing distributions.
}
\examples{
##simulate data
n=150
dat<-data.frame(Ydep=runif(n,0.3,1.4))
Ydep <- as.matrix(dat, -1,ncol=ncol(dat))
littlerho=0.95
r0=1
rho=diag(r0)*littlerho
p=4
n=4.1
T=nrow(Ydep)
Xdep <- Ydep[p:(T-1),]
if (p>1){
for(lagi in 2:p){
  Xdep <- cbind(Xdep, Ydep[(p-lagi+1):(T-lagi),])
}
}
T=nrow(Ydep)
 Ydep <- as.matrix(Ydep[(p+1):T,])
 T=nrow(Ydep)
unos <- rep(1,T)
Xdep <- cbind(unos, Xdep)
##obtain residuals
bOLS <- solve(t(Xdep) \%*\% Xdep) \%*\% t(Xdep) \%*\% Ydep
Res= Ydep- Xdep \%*\% bOLS
 Res=Res[1:T,1]
 b2=solve(t(Res) \%*\% Res/T)*(1-rho \%*\% rho)/(n-2)
 Res=as.matrix(Res,ncol=1)
 
##obtain log likelihood
LL1=lik_clo(Res,b2,n,rho)
LL1[1]
}
