% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idiffomix.R
\name{idiffomix}
\alias{idiffomix}
\title{The idiffomix function}
\usage{
idiffomix(
  seq_data,
  meth_data,
  gene_chr,
  N,
  K = 3,
  L = 3,
  probs = c(0.1, 0.9),
  parallel_process = FALSE
)
}
\arguments{
\item{seq_data}{A dataframe of dimension \eqn{G \times (N+1)} containing log-fold change values for all G genes and N patients}

\item{meth_data}{A dataframe of dimension \eqn{C \times (N+2)} containing M-value differences between the two biological conditions for all $C$ CpG sites and $N$ patients along with the associated genes for each CpG site.}

\item{gene_chr}{A dataframe containing the genes and their corresponding chromosome number.}

\item{N}{Number of patients in the study.}

\item{K}{Number of clusters for expression data (default = 3; E-,E0,E+).}

\item{L}{Number of clusters for methylation data (default = 3; M-,M0,M+).}

\item{probs}{Quantile probabilities for initialization (default = c(0.1,0.9)).}

\item{parallel_process}{The "TRUE" option results in parallel processing of the models for increased computational efficiency. The default option has been set as "FALSE" due to package testing limitations.}
}
\value{
The function returns an object of the \code{\link[idiffomix:idiffomix]{idiffomix}} class which contains the following values:
\itemize{
\item tau - The proportion of genes belonging to K clusters.
\item pi - A matrix containing the probability of a CpG site belonging to cluster \emph{l}, given its associated associated gene belongs to cluster \emph{k}.
\item mu - The mean for each component of the gene expression data. If there is more than one component, this is a matrix whose \emph{k}th column is the mean of the \emph{k}th component of the mixture model.
\item sigma - The variance for each component of the gene expression data.
\item lambda - The mean for each component of the methylation data. If there is more than one component, this is a matrix whose \emph{l}th column is the mean of the \emph{l}th component of the mixture model.
\item rho - The variance for each component of the methylation data.
\item N - The number of patients analysed using the beta mixture models.
\item R - The number of sample types analysed using the beta mixture models.
\item U - A dataframe containing the posterior probabilities of genes belonging to the \emph{K} clusters.
\item V - A dataframe containing the posterior probabilities of CpG sites belonging to the \emph{L} clusters.
\item seq_classification - A dataframe containing the log-fold change for gene expression data and their classification corresponding to U.
\item meth_classification - A dataframe containing the differences in M-values for methylation data and their classification corresponding to V.
}
}
\description{
Integrated differential analysis of multi-omics data using a joint mixture model
}
\details{
This is a function to fit the joint mixture model to the transformed and filtered gene expression and methylation data.
}
\examples{
N <- 4
data_transformed = data_transformation(seq_data=gene_expression_data,
                                  meth_data=methylation_data,
                                  gene_chr=gene_chromosome_data,
                                  N=N)
data_output = idiffomix(seq_data=data_transformed$seq_transformed,
                        meth_data=data_transformed$meth_transformed,
                        gene_chr=gene_chromosome_data,
                        N=N, K=3, L=3, probs=c(0.25,0.75),
                        parallel_process = FALSE)

}
