% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariableSelectionNew.R
\name{JaccardRate}
\alias{JaccardRate}
\title{Jaccard Rate}
\usage{
JaccardRate(
  data, 
  data_red,
  k=6
)
}
\arguments{
\item{data}{A data frame. Values of type 'numeric' or 'integer' are treated as numerical.}

\item{data_red}{A data frame. A subset of data with the selected features.}

\item{k}{number of neighbors}
}
\value{
   \item{Jaccard Index}{numeric}
}
\description{
Computes the Jaccard index using Gower's dissimilarity.
}
\references{
Zhao, Z., L. Wang, and H. Liu (2010). Efficient spectral feature selection with minimum redundancy.
In Proceedings of the AAAI conference on artificial intelligence, Volume 24, pp. 673–678.

}
\examples{

data(ESI)
data=ESI[,-c(1,3,4,6,9)] ##removing categorical features
out=UFS(data,alpha=0.01,method='c',pv_adj='BH')
JR=JaccardRate(data,out$selected.features)
JR #visualize the index
}
