% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{meniscal_list}
\alias{meniscal_list}
\title{Meniscal Repairs Load at Failure}
\format{
A list with 3 numeric components, each containing 6 observations:
\describe{
  \item{FasT-Fix}{Numeric vector. Load at failure values for menisci repaired with the FasT-Fix system.}
  \item{Meniscus Arrows}{Numeric vector. Load at failure values for menisci repaired with biodegradable Meniscus Arrows.}
  \item{Vertical Mattress}{Numeric vector. Load at failure values for menisci repaired with Vertical Mattress Sutures.}
}
}
\source{
Data taken from the \pkg{IIS} package, version 1.1.
}
\usage{
data(meniscal_list)
}
\description{
This dataset, meniscal_list, contains the load at failure for 18 cadaveric menisci
repaired by one of three techniques: the FasT-Fix Meniscal Repair Suture System (FasT-Fix),
the use of biodegradable Meniscus Arrows (MA), and the Vertical Mattress Sutures (VMS) approach.
The data are also presented in Table 12.1 of Wolfe and Schneider - Intuitive Introductory Statistics.
}
\details{
The dataset name has been kept as 'meniscal_list' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
healthmotionR package and assists users in identifying its specific characteristics.
The suffix 'list' indicates that the dataset is stored as a list structure.
The original content has not been modified in any way.
}
