% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_api.R
\name{childpos_to_cell}
\alias{childpos_to_cell}
\title{Child position to cell}
\usage{
childpos_to_cell(
  child_pos = NULL,
  h3_address = NULL,
  child_res = NULL,
  simple = TRUE
)
}
\arguments{
\item{child_pos}{numeric; position of the child cell to get.}

\item{h3_address}{Character; 15-character index generated by H3.}

\item{child_res}{numeric; resolution of the child cell to return.}

\item{simple}{Logical; whether to return a vector or a data frame containing
both inputs and outputs.}
}
\value{
Character, H3 address of child
}
\description{
Get the child cell at a given position within an ordered list of all children at the specified resolution.
}
\note{
`child_pos` is 0-indexed and capped at the maximum number of hexagons within the parent cell at the supplied resolution. This figure can be determined using \code{\link[h3jsr:cell_to_children_size]{cell_to_children_size}}.
}
\examples{
# example address has resolution 7:
childpos_to_cell(0, '872830b82ffffff', 9, simple = FALSE)
}
