% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_methods.R
\name{analyze_syntax}
\alias{analyze_syntax}
\title{analyze_syntax}
\usage{
analyze_syntax(text_body, flatten = TRUE)
}
\arguments{
\item{text_body}{The text string to send to the API.}

\item{flatten}{If \code{TRUE} (default), then the results of each method are flattened and converted to a data frame.}
}
\value{
A list containing three elements: \code{sentences}, \code{tokens}, and \code{language}.

If \code{flatten} is \code{TRUE}, then the \code{sentences} and \code{tokens} elements are each converted to data frames.
}
\description{
Send a request, and retrieve the \code{sentences}, \code{tokens}, and \code{language} responses.
This function retrieves the results from the \href{https://cloud.google.com/natural-language/reference/rest/v1/documents/analyzeSyntax}{analyzeSyntax} method.
}
\examples{
\dontrun{
sample_syntax <- analyze_syntax(text_body = "Google, headquartered in Mountain View, unveiled
                                       the new Android phone at the Consumer Electronic Show.
                                       Sundar Pichai said in his keynote that users love
                                       their new Android phones.",
                                flatten = TRUE)
sample_syntax$sentences
sample_syntax$tokens
sample_syntax$language
}

}
