% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{threshold}
\alias{threshold}
\title{Threshold}
\usage{
threshold(lower_bound, upper_bound, var, data)
}
\arguments{
\item{lower_bound}{a number indicating the lower bound of the threshold.}

\item{upper_bound}{a number indicating the upper bound of the threshold.}

\item{var}{a string specifying the treatment variable for the intervention.}

\item{data}{a data frame containing the observed data.}
}
\value{
a vector containing the intervened values of the same size as the number of rows in \code{data}.
}
\description{
This function specifies the threshold intervention on the treatment variable in \code{data}.
If treatment value is between the lower bound and the upper bound, it follows the natural value of the treatment. 
If treatment value is either below the lower bound or above the upper bound, it is set to the lower bound or the upper bound, correspondingly.
See Young et al. (2014) for more details.
}
\examples{
data <- gfoRmulaICE::compData
threshold_treat <- threshold(lower_bound = 0, upper_bound = 2, var = "A1", data = data)
}
\references{
Young JG, Herńan MA, Robins JM. Identification, estimation and approximation of risk under interventions that depend on the natural value of treatment using observational data. Epidemiologic Methods. 2014;3(1):1-19.
}
