% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11-visualization.R
\name{plot_rgb_raster}
\alias{plot_rgb_raster}
\title{Create multi-band raster RGB plot}
\usage{
plot_rgb_raster(
  raster_data,
  r = 1,
  g = 2,
  b = 3,
  stretch = "lin",
  title = "RGB Composite",
  output_file = NULL,
  verbose = FALSE
)
}
\arguments{
\item{raster_data}{Multi-band SpatRaster or file path}

\item{r}{Red band index (default: 1)}

\item{g}{Green band index (default: 2)}

\item{b}{Blue band index (default: 3)}

\item{stretch}{Stretch method: "lin", "hist", "minmax", "perc"}

\item{title}{Plot title}

\item{output_file}{Optional output file path}

\item{verbose}{Print progress messages}
}
\value{
NULL (plots directly to device) or file path if saved
}
\description{
Create RGB plots from multi-band rasters using terra's native RGB plotting.
Reliable and fast without external dependencies.
}
\examples{
\dontrun{
# These examples require external data files not included with the package
# True color composite
plot_rgb_raster(satellite_data, r = 3, g = 2, b = 1, title = "True Color")

# False color composite with histogram stretch
plot_rgb_raster(landsat_data, r = 4, g = 3, b = 2, stretch = "hist",
               title = "False Color Composite", output_file = "rgb_composite.png")
}

}
