% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeChips.R
\name{makeChips}
\alias{makeChips}
\title{makeChips}
\usage{
makeChips(
  image,
  mask,
  n_channels = 3,
  size = 256,
  stride_x = 256,
  stride_y = 256,
  outDir,
  mode = "All",
  useExistingDir = FALSE
)
}
\arguments{
\item{image}{SpatRaster object or path to input image. Function will generate a SpatRaster object
internally. The image and mask must have the same extent, number of rows and
columns of pixels, cell size, and coordinate reference system.}

\item{mask}{SpatRaster object or path to single-band mask. Function will generate a SpatRaster
object internally. The image and mask must have the same extent, number of
rows and columns of pixels, cell size, and coordinate reference system.}

\item{n_channels}{Number of channels in the input image. Default is 3.}

\item{size}{Size of image chips as number of rows and columns of pixels.
Default is 256.}

\item{stride_x}{Stride in the x (columns) direction. Default is 256.}

\item{stride_y}{Stride in the y (rows) direction. Default is 256.}

\item{outDir}{Full or relative path to the current working directory where you
want to write the chips to. Subfolders in this directory will be generated by
the function if useExistingDir = FALSE. You must include the final forward slash
in the file path (e.g., "C:/data/chips/").}

\item{mode}{Either "All", "Positive", or "Divided". Please see the explanations
provided above. The default is "All".}

\item{useExistingDir}{TRUE or FALSE. Write chips into an existing directory
with subfolders already defined as opposed to using a new directory. This can be used
if you want to add chips to an existing set of chips. However, the "mode" should
be the same as that used to generated the original chips. Default is FALSE.}
}
\value{
Image and mask files written to disk in TIFF format. No R object is returned.
}
\description{
Generate image chips from images and associated raster masks
}
\details{
This function generates image and mask chips from an input image and
associated raster mask. The chips are written into the defined directory.
The number of rows and columns of pixels in each chip are equal to the
size argument. If a stride_x and/or stride_y is used that is different from
the size argument, resulting chips will either overlap or have gaps between
them. In order to not have overlap or gaps, the stride_x and stride_y arguments
should be the same as the size argument. Both the image chips and associated
masks are written to TIFF format (".tif"). Input data are not limited to three
band images. This function is specifically for a binary classification where
the positive case is indicated with a cell value of 1 and the background or
negative case is indicated with a cell value of 0. If an irregular shaped raster
grid is provided, only chips and masks that contain no NA or NoDATA cells will
be produced.

Three modes are available. If "All" is used, all image chips are
generated even if they do not contain pixels mapped to the positive case.
Within the provided directory, image chips will be written to an "images" folder
and masks will be written to a "masks" folder. If "Positive" is used, only chips
that have at least 1 pixel mapped to the positive class will be produced. Background-
only chips will not be generated. Within the provided directory, image chips will
be written to an "images" folder and masks will be written to a "masks" folder.
Lastly, if the "Divided" method is used, separate "positive" and "background"
folders will be created with "images" and "masks" subfolders. Any chip that has
at least 1 pixel mapped to the positive class will be written to the "positive"
folder while any chip having only background pixels will be written to the
"background" folder.
}
\examples{
\dontrun{
makeChips(image = "INPUT IMAGE FILE NAME AND PATH",
          mask = "INPUT RASTER MASK FILE NAME AND PATH",
          n_channels = 3,
          size = 256,
          stride_x = 256,
          stride_y = 256,
          outDir = "OUTPUT DIRECTY IN WHICH TO SAVE CHIPS",
          mode = "Positive",
          useExistingDir=FALSE)
}
}
