% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-liureg.R
\name{summary.liureg}
\alias{summary.liureg}
\title{Summarizing Liu Regression Fit}
\usage{
\method{summary}{liureg}(object, digits, ...)
}
\arguments{
\item{object}{An object of class \code{liureg}.}

\item{digits}{Number of decimal places in the data frame of Liu regression statistics.}

\item{...}{Not used in this implemetation.}
}
\value{
The returned object is a list whose elements are Liu
regression coefficient estimates and statistics related to Liu regression.
}
\description{
\code{summary} method for \code{liureg} objects.
}
\details{
\code{summary.liureg} produces an object with S3 class \code{summary.liureg}.
The function returns a list of summary statistics of the Liu regression fit for the grid
of regularization parameter \eqn{\lambda} values. Each element of the output list includes:
\tabular{ll}{
\code{coefficients} \tab A \eqn{p\times 5} matrix with columns coefficient estimates,
scaled coefficient estimates, scaled standard errors, scaled \eqn{t-}values with corresponding
\eqn{p-}value.\cr
\tab \cr
\code{Statistics} \tab Liu related statistics \eqn{R^2}, \eqn{\textrm{adjusted}-R^2},
\eqn{F-}statistics, AIC, BIC and MSE values.\cr
\tab \cr
}
}
\examples{
Hitters <- na.omit(Hitters)
X <- model.matrix(Salary ~ ., Hitters)[, -1]
y <- Hitters$Salary
lam <- seq(0, 1, 0.01)
liu.mod <- liureg(X, y, lam)
summary(liu.mod)
}
\seealso{
\code{\link[=liureg]{liureg()}}, \code{\link[=coef]{coef()}}, \code{\link[=predict]{predict()}}, \code{\link[=residuals]{residuals()}}
}
\author{
Murat Genç
}
