% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print-statliu.R
\name{print.statliu}
\alias{print.statliu}
\title{Print Method for Liu Regression Statistics}
\usage{
\method{print}{statliu}(x, digits = 5, ...)
}
\arguments{
\item{x}{A \code{statliu} object}

\item{digits}{Number of decimal places in the data frame of Liu regression statistics.}

\item{...}{Other parameters related to \code{print}.}
}
\value{
The return object is the statistics relatec to the Liu regression.
}
\description{
\code{statliu} computes the statistics related to the Liu regression.
}
\examples{
Hitters <- na.omit(Hitters)
X <- model.matrix(Salary ~ ., Hitters)[, -1]
y <- Hitters$Salary
lam <- seq(0, 1, 0.01)
liu.mod <- liureg(X, y, lam)
stats <- statliu(liu.mod)
print(stats)
}
\seealso{
\code{\link[=liureg]{liureg()}}, \code{\link[=summary]{summary()}}, \code{\link[=pressliu]{pressliu()}}, \code{\link[=residuals]{residuals()}}
}
\author{
Murat Genç
}
