% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{polyserial}
\alias{polyserial}
\title{Polyserial Correlation}
\usage{
polyserial(x, y)
}
\arguments{
\item{x}{A numeric vector representing the continuous variable.}

\item{y}{A numeric vector representing the ordinal variable (must be integer values).}
}
\value{
A numeric value representing the estimated polyserial correlation coefficient.
}
\description{
Calculates the polyserial correlation coefficient between a continuous variable and an ordinal variable.
}
\details{
This function implements Olsson et al.'s ad hoc method for estimating the polyserial correlation
coefficient. The method assumes that the continuous variable follows a normal distribution and
that the ordinal variable is derived from an underlying continuous normal variable through
thresholds.
}
\examples{
n <- 300
x <- rnorm(n)
y <- sample(1:5, size = n, replace = TRUE)
polyserial(x, y)
}
\references{
U.Olsson, F.Drasgow, and N.Dorans (1982).
The polyserial correlation coefficient. Psychometrika, 47,337-347.
}
