% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{ItemThreshold}
\alias{ItemThreshold}
\alias{ItemThreshold.binary}
\alias{ItemThreshold.ordinal}
\title{Item Threshold}
\usage{
ItemThreshold(U, na = NULL, Z = NULL, w = NULL)

\method{ItemThreshold}{binary}(U, na = NULL, Z = NULL, w = NULL)

\method{ItemThreshold}{ordinal}(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{Either an object of class "exametrika" or raw data. When raw data is given,
it is converted to the exametrika class with the \code{\link{dataFormat}} function.}

\item{na}{Values to be treated as missing values.}

\item{Z}{Missing indicator matrix of type matrix or data.frame. Values of 1 indicate
observed responses, while 0 indicates missing data.}

\item{w}{Item weight vector specifying the relative importance of each item.}
}
\value{
A numeric vector of threshold values for each item on the standard normal scale.
Typical values range from about -3 to 3, where:
\itemize{
\item Positive values indicate difficult items
\item Zero indicates items of medium difficulty (50\% correct)
\item Negative values indicate easy items
}
}
\description{
Item threshold is a measure of difficulty based on a standard normal distribution.
This function is applicable only to binary response data.

The threshold is calculated as:
\deqn{\tau_j = \Phi^{-1}(1-p_j)}
where \eqn{\Phi^{-1}} is the inverse standard normal distribution function
and \eqn{p_j} is the correct response rate for item j.

Higher threshold values indicate more difficult items, as they represent the
point on the standard normal scale above which examinees tend to answer incorrectly.
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.
}
\examples{
# using sample dataset
ItemThreshold(J5S10)
}
