% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregateData.R
\name{aggregateData}
\alias{aggregateData}
\title{Aggregate event report data}
\usage{
aggregateData(
  data,
  group_var = "event_id",
  find_mode = NULL,
  find_mode_na_ignore = NULL,
  find_mode_bin = NULL,
  find_mode_date = NULL,
  find_mode_numeric = NULL,
  find_least_precise = NULL,
  find_most_precise = NULL,
  combine_strings = NULL,
  find_max = NULL,
  find_min = NULL,
  summarize_vars = NULL,
  aggregation_name = NULL,
  tie_break = "default_tie_break",
  second_tie_break = "default_tie_break"
)
}
\arguments{
\item{data}{A data frame containing the data to be aggregated.}

\item{group_var}{A string specifying the variable to group by. Default is "event_id".}

\item{find_mode}{A vector of variable names for which to find the mode.}

\item{find_mode_na_ignore}{A vector of variable names for which to find the mode, ignoring NAs.}

\item{find_mode_bin}{A vector of variable names for which to find the binary mode.}

\item{find_mode_date}{A vector of variable names for which to find the mode for dates.}

\item{find_mode_numeric}{A vector of variable names for which to find the mode for numeric values.}

\item{find_least_precise}{A list of lists, each containing a variable name and its corresponding precision variable, to find the least precise value.}

\item{find_most_precise}{A list of lists, each containing a variable name and its corresponding precision variable, to find the most precise value.}

\item{combine_strings}{A vector of variable names for which to combine strings.}

\item{find_max}{A vector of variable names for which to find the maximum value.}

\item{find_min}{A vector of variable names for which to find the minimum value.}

\item{summarize_vars}{A vector of variable names for which to sum all values.}

\item{aggregation_name}{A string specifying the name of the aggregation.}

\item{tie_break}{A string specifying the tie break column name. Default is "default_tie_break".}

\item{second_tie_break}{A string specifying the second tie break column name. Default is "default_tie_break".}
}
\value{
A data frame with the aggregated results.
}
\description{
This function aggregates event report data based on a specified grouping variable and various aggregation criteria.
}
\examples{
small_maverick_event_report \%>\%
  aggregateData(group_var = "event_id", find_mode = "city") \%>\%
  utils::head(10)
}
