% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consist.test.R
\name{consist.test}
\alias{consist.test}
\title{The Consistency Test for Grouped Average Treatment Effects (GATEs) in Randomized Experiments}
\usage{
consist.test(T, tau, Y, ngates = 5, nsim = 10000)
}
\arguments{
\item{T}{A vector of the unit-level binary treatment receipt variable for each sample.}

\item{tau}{A vector of the unit-level continuous score. Conditional Average Treatment Effect is one possible measure.}

\item{Y}{A vector of the outcome variable of interest for each sample.}

\item{ngates}{The number of groups to separate the data into. The groups are determined by \code{tau}. Default is 5.}

\item{nsim}{Number of Monte Carlo simulations used to simulate the null distributions. Default is 10000.}
}
\value{
A list that contains the following items: \item{stat}{The estimated
statistic for the test of consistency} \item{pval}{The p-value of the null
hypothesis (that the treatment effects are consistent)}
}
\description{
This function calculates statistics related to the test of treatment effect consistency across groups.
}
\details{
The details of the methods for this design are given in Imai and Li (2022).
}
\examples{
T = c(1,0,1,0,1,0,1,0)
tau = c(0,0.1,0.2,0.3,0.4,0.5,0.6,0.7)
Y = c(4,5,0,2,4,1,-4,3)
consisttestlist <- consist.test(T,tau,Y,ngates=5)
consisttestlist$stat
consisttestlist$pval
}
\references{
Imai and Li (2022). \dQuote{Statistical Inference for Heterogeneous Treatment Effects Discovered by Generic Machine Learning in Randomized Experiments},
}
\author{
Michael Lingzhi Li, Technology and Operations Management, Harvard Business School
\email{mili@hbs.edu}, \url{https://www.michaellz.com/};
}
\keyword{evaluation}
