% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spread_paths.R
\name{spread_paths}
\alias{spread_paths}
\title{Spread the information in dose_finding_paths object to a wide data.frame format.}
\usage{
spread_paths(df = NULL, dose_finding_paths = NULL, max_depth = NULL)
}
\arguments{
\item{df}{Optional \code{data.frame} like that returned by
as_tibble(dose_finding_paths). Columns .depth, .node, .parent are required.
All other columns are spread with a suffix reflecting depth.}

\item{dose_finding_paths}{Optional instance of dose_finding_paths. Required
if `df` is null.}

\item{max_depth}{integer, maximum depth of paths to traverse.}
}
\value{
A data.frame
}
\description{
Spread the information in dose_finding_paths object to a wide data.frame format.
}
\examples{
\dontrun{
# Calculate paths for the first two cohorts of three patients a CRM trial
skeleton <- c(0.05, 0.1, 0.25, 0.4, 0.6)
target <- 0.25
cohort_sizes <- c(3, 3)
paths <- get_dfcrm(skeleton = skeleton, target = target) \%>\%
  get_dose_paths(cohort_sizes = cohort_sizes)
}
}
