% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disease_results.R
\name{disease_results}
\alias{disease_results}
\title{Nested functions for initializing, calculating and collecting disease
simulator results.}
\usage{
disease_results(
  replicates,
  time_steps,
  seasons,
  stages,
  compartments,
  coordinates,
  initial_abundance,
  results_selection = NULL,
  results_breakdown = NULL
)
}
\arguments{
\item{replicates}{Number of replicate simulation runs.}

\item{time_steps}{Number of simulation time steps.}

\item{seasons}{Number of seasons per time step.}

\item{stages}{Number of life cycle stages.}

\item{compartments}{Number of disease compartments.}

\item{coordinates}{Data frame (or matrix) of X-Y population coordinates.}

\item{initial_abundance}{Matrix of initial abundances at each combination of
stage and compartment (in rows) for each population (in columns).}

\item{results_selection}{List of results selection from: "abundance"
(default), "ema", "extirpation", "extinction_location", "harvested",
"occupancy"; "summarize" (default) or "replicate". "summarize" calculates
mean, sd, min and max across replicates. "replicate" returns results
separately for each replicate.}

\item{results_breakdown}{A string with one of these values: "segments" (default),
"compartments", "stages" or "pooled." "segments" returns results for each
segment (stage x compartment combination.) "compartments" returns results for
each disease compartment. "stages" returns results for each life cycle stage.
"pooled" returns results that are not broken down by stage or compartment.}
}
\value{
List of result functions:
\describe{
\item{\code{initialize_attributes = function())}}{Constructs and returns
an initialized nested list for the selected result attributes.}
\item{\code{initialize_replicate = function(results)}}{Initializes and
returns nested result attributes at the start of each replicate.}
\item{\code{calculate_at_season = function(r, tm, season,
    segment_abundance, harvested, results)}}{Appends and calculates
(non-NULL) results and returns nested result attributes at the end of
each season within time step (tm) within replicate (r).}
\item{\code{calculate_at_timestep = function(r, tm, segment_abundance,
    harvested, results)}}{Appends and calculates (non-NULL) results and
returns nested result attributes at the end of each time step (tm) within
replicate (r).}
\item{\code{finalize_attributes = function(results)}}{Finalizes result
calculations at the end of the simulation.}
}
}
\description{
Modular functions for the disease simulator for initializing, calculating and
collecting simulator results.
}
