% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_population.R
\name{gen_population}
\alias{gen_population}
\title{Generate population counts from estimated population age breakdowns.}
\usage{
gen_population(
  total_pop = 1000,
  groups = c("0-4", "5-14", "15-29", "30-44", "45+"),
  strata = c("Male", "Female"),
  proportions = c(0.079, 0.134, 0.139, 0.082, 0.066),
  counts = NULL,
  tibble = TRUE
)
}
\arguments{
\item{total_pop}{The overal population count of interest - the default is
1000 people}

\item{groups}{A character vector of groups - the default is set for age
groups: c("0-4","5-14","15-29","30-44","45+")}

\item{strata}{A character vector for stratifying groups -
the default is set for gender: c("Male", "Female")}

\item{proportions}{A numeric vector specifying the proportions (as decimals)
for each group of the total_pop.
The default repeats c(0.079, 0.134, 0.139, 0.082, 0.067)
for strata.  However you can change this manually, make sure to
have the length equal to groups times strata (or half thereof).
These defaults are based of MSF general emergency intervention standard
values.}

\item{counts}{A numeric vector specifying the counts for each group.
The default is NULL - as most often proportions above will be used.
If is not NULL then total_pop and proportions will be ignored.
Make sure the length of this vector is equal to groups times strata (or if it
is half then it will repeat for each strata).
For reference, the MSF general emergency intervention standard values
are c(7945, 13391, 13861, 8138, 6665) based on above
groups for a 100,000 person population.}

\item{tibble}{Return data as a tidyverse tibble (default is TRUE)}
}
\description{
This generates based on predefined age groups and proportions,
however you could also define these yourself.
}
\examples{
# get population counts based on proportion, unstratified
gen_population(groups = c(1, 2, 3, 4), 
               strata = NULL, 
               proportions = c(0.3, 0.2, 0.4, 0.1))

# get population counts based on proportion, stratified
gen_population(groups = c(1, 2, 3, 4), 
               strata = c("a", "b"), 
               proportions = c(0.3, 0.2, 0.4, 0.1))

# get population counts based on counts, unstratified
gen_population(groups = c(1, 2, 3, 4), 
               strata = NULL, 
               counts = c(20, 10, 30, 40))

# get population counts based on counts, stratified
gen_population(groups = c(1, 2, 3, 4), 
               strata = c("a", "b"), 
               counts = c(20, 10, 30, 40))

# get population counts based on counts, stratified - type out counts
# for each group and strata
gen_population(groups = c(1, 2, 3, 4), 
               strata = c("a", "b"), 
               counts = c(20, 10, 30, 40, 40, 30, 20, 20))
}
