% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_truth_functions.R
\name{make.truth}
\alias{make.truth}
\alias{make.truth.ex.bad}
\alias{make.truth.opt.bad}
\alias{make.truth.opt.bad.strat}
\alias{make.ok.truth}
\title{Make baseline truth for simulations}
\usage{
make.truth.ex.bad(Z)

make.truth.opt.bad(Z, strata = "strata", bound = c("margin", "WPM"), t = 0)

make.truth.opt.bad.strat(Z, strata = "strata", t = 3, shuffle.strata = FALSE)

make.ok.truth(Z, num.off = 8, amount.off = 5)
}
\arguments{
\item{Z}{The elec.data to build from.}

\item{strata}{name of column holding strata, if any.}

\item{bound}{What sort of maximum error can be held in a precinct.}

\item{t}{an allowed backgound level of error for all precincts}

\item{shuffle.strata}{Should the error be randomly put in the strata?}

\item{num.off}{Number of precincts that should have small errors.  Direction
of errors split 50-50 positive and negative.}

\item{amount.off}{Size of the small errors that should be imposed.}
}
\value{
Another elec.data matrix with the same candidates and total ballot
counts as the passed frame, but with different candidate totals and
by-precinct votes.  Can be used to test the power or actual confidence of
the various auditing procedures.

WARNING: make.ok.truth randomly adds votes and can thus sometimes exceed the
allowed ballot count for a precinct by small amounts.

WARNING: If the desired bound is WPM, the error in make.opt.bad.truth is
made by simply adding the maximum allowed amount of error in votes to the
first loser's total (so that total votes may in this case exceed the total
votes of the precinct)--this could potentially cause trouble.  Be careful!

WARNING: \code{make.truth.ex.bad} and \code{make.truth.opt.bad.strat} only
work in conjunction with the \code{\link{make.cartoon}} method.
}
\description{
For simulations.  These methods, given an elec.data object, make a
``truth''---i.e. a different vote count---that meets the same precinct and
tot.votes structure, but has potentially different results and outcomes.

\code{make.truth.opt.bad} makes the ``optimally worse truth'', where the
error needed to flip the winner and runner-up is packed into as a few
precincts as possible.

\code{make.ok.truth} makes the truth have the same outcome as the reported,
but some errors here and there.

Warning: if bound is WPM this error is made by simply adding the max amount of error
to the first loser's total (so that total votes may in this case exceed the total votes
of the precinct)--this could potentially cause trouble.  Be careful!

make bad truth as described in Stark's paper (assuming fixed precinct size)
}
\examples{

## First make a fake election.
Z = make.sample(0.08, 150, per.winner=0.4, R=2.2)
Z

## Now make a fake truth, which has a lot of small errors:
Zb = make.ok.truth(Z, num.off=150, amount.off=5)
Zb

## Finally, make the hardest to detect (via SRS) ``wrong'' election:
Zw = make.truth.opt.bad( Z, t=4 )
Zw 
}
\seealso{
\code{\link{elec.data}} \code{\link{make.sample}}
\code{\link{do.audit}} \code{\link{make.cartoon}}
}
\author{
Luke W. Miratrix
}
