% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audit.plan.R
\name{audit.plan}
\alias{audit.plan}
\alias{is.audit.plan}
\alias{print.audit.plan}
\alias{is.audit.plan.tri}
\alias{print.audit.plan.tri}
\title{Audit Plans for CAST and Trinomial Methods}
\usage{
is.audit.plan(x)

\method{print}{audit.plan}(x, ...)

is.audit.plan.tri(x)

\method{print}{audit.plan.tri}(x, ...)
}
\arguments{
\item{x}{object to check}

\item{...}{No extra options passed.}

\item{audit.plan}{to print.}

\item{audit.plan.tri}{to print.}
}
\value{
is.audit.plan: TRUE if object is an audit.plan object.

print: No return value; prints results.

is.audit.plan.tri: TRUE if object is an audit.plan.tri object.

print: No return value; prints results.
}
\description{
An \code{audit.plan} is returned by CAST.calc.sample, containing details of
how to audit for a desired level of confidence.  It has a print method for
pretty output.

The \code{audit.plan.tri}, similarly, is an object that holds information
about conduting a PPEB election audit, in particular an audit that will use
the trinomial bound to analyze resultant audit data.  It is what is returned
by the tri.calc.sample method.

Theoretically, auditors will use the plan and go out and generate actual
audit data.  (You can fake it with simulations--see \link{make.truth}.)  The
audit data should be stored in a new data frame with new vote totals, or
overstatements, for the candidates in the audited precincts. To convert from
totals to overstatements, use \code{\link{audit.totals.to.OS}}.  You can
store that in a elec.data object under ``audit'', or keep it seperate.
}
\seealso{
\link{CAST.calc.sample} \link{tri.calc.sample}
}
\author{
Luke W. Miratrix
}
\keyword{manip}
