% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_plot.R
\name{performance_plot}
\alias{performance_plot}
\title{Performance Analysis Plotting Function}
\usage{
performance_plot(
  perfDF,
  title = "Performance Analysis Results",
  subtitle = NULL,
  legend_name = "Preferred Candidate:",
  preferred_cand_races = NULL,
  colors = NULL,
  breaks = seq(0, 100, 20),
  lims = c(0, 100),
  bar_size = 5,
  label_size = 4,
  position_dodge_width = 0.8,
  cand_name_size = 6,
  cand_name_pad = -1,
  contest_name_size = 20,
  contest_name_pad = NULL,
  panel_spacing = 0.7,
  panelBy = "Jurisdiction",
  includeCandName = TRUE,
  includeMeanDiff = TRUE
)
}
\arguments{
\item{perfDF}{A data.frame object containing performance analysis results 
from \code{performance()}}

\item{title}{The plot title}

\item{subtitle}{The plot subtitle}

\item{legend_name}{The legend title}

\item{preferred_cand_races}{A character vector of the unique races contained 
in the \code{preferred_candidate} column of \code{perfDF}. This argument is
optional and is used with \code{colors} to indicate the color of the plot 
associated with the race preferences.}

\item{colors}{Plot colors for the voter race groups. Colors must 
be listed in the desired order with respect \code{preferred_cand_races} if 
arguments are used together.}

\item{breaks}{Numeric vector containing x axis breaks}

\item{lims}{Numeric vector containing x axis limits}

\item{bar_size}{The size of plot bars. Passed to \code{geom_linerange()}.}

\item{label_size}{The size of vote share labels}

\item{position_dodge_width}{The width value passed to \code{position_dodge()}.
Affects spacing between the plot bars.}

\item{cand_name_size}{Text size of candidate names if \code{includeCandName = TRUE}}

\item{cand_name_pad}{Padding between candidate name and y axis if 
\code{includeCandName = TRUE}.}

\item{contest_name_size}{Text size of contest name}

\item{contest_name_pad}{Padding between contest name and y axis}

\item{panel_spacing}{space between panels. This argument is relevant only if 
there are multiple jurisdictions in \code{perfDF}.}

\item{panelBy}{Column name from perfDF passed to \code{facet_grid()} to 
create panels. Recommended options are Jurisdiction and Map. 
Defaults to Jurisdiction.}

\item{includeCandName}{Logical indicating if candidate names should appear 
on the left side of the plot.}

\item{includeMeanDiff}{Logical indicating if the mean difference between 
preferred_candidate  across all elections should appear in the plot.}
}
\value{
ggplot visualization of performance analysis
}
\description{
Uses output from \code{performance()} to create a ggplot
 performance analysis visualization.
}
\examples{
library(eiExpand)
data(example_performance_results)
performance_plot(example_performance_results)

#ggplot2::ggsave("perf_plot.png", width = 12, height = 7)
}
\seealso{
\link{performance}
}
\author{
Rachel Carroll <rachelcarroll4@gmail.com>
}
