% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2convert_to_rds.R
\name{convert_to_rds}
\alias{convert_to_rds}
\title{Convert all PSID files from .txt format to .rds format}
\usage{
convert_to_rds(in_direc, out_direc)
}
\arguments{
\item{in_direc}{Directory containing unzipped PSID .txt and .do files}

\item{out_direc}{Directory to place PSID .rds files into}
}
\description{
Converts all PSID fixed width format .txt files in a selected directory into .rds format. Importantly, this function assumes that all files contained in the original PSID .zip files (especially those ending in .do) are present in the same directory as the PSID .txt files, and that all files within that directory have the same names as when first unzipped.
}
\examples{
convert_to_rds(
    in_direc=system.file("extdata","unzip_dir", package = "easyPSID"),
    out_direc=tempdir()
)
}
\keyword{PSID}
