% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_fun.R
\name{map_text_chars}
\alias{map_text_chars}
\title{map_text_chars maps the characters of a text string into a table (with x/y coordinates).}
\usage{
map_text_chars(x, flip_y = FALSE)
}
\arguments{
\item{x}{The text string(s) to map (required). 
If \code{length(x) > 1}, elements are mapped to different lines 
(i.e., y-coordinates).}

\item{flip_y}{Boolean: Should y-coordinates be flipped, 
so that the lowest line in the text file becomes \code{y = 1}, 
and the top line in the text file becomes \code{y = n_lines}? 
Default: \code{flip_y = FALSE}.}
}
\value{
A data frame with 3 variables: 
Each character's \code{x}- and \code{y}-coordinates (from top to bottom)  
and a variable \code{char} for the character at this coordinate.
}
\description{
\code{map_text_chars} parses text 
(from a text string \code{x}) 
into a table that contains a row for each character 
and x/y-coordinates corresponding to the character positions in \code{x}.
}
\details{
\code{map_text_chars} creates a data frame with 3 variables: 
Each character's \code{x}- and \code{y}-coordinates (from top to bottom)  
and a variable \code{char} for the character at these coordinates. 

Note that \code{map_text_chars} was originally a part of 
\code{\link{read_ascii}}, but has been separated to 
enable independent access to separate functionalities. 

Note that \code{map_text_chars} is replaced by the simpler 
\code{map_text_coord} function.
}
\seealso{
\code{\link{read_ascii}} for parsing text from file or user input;  
\code{\link{plot_chars}} for a character plotting function.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{capitalize}()},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{chars_to_text}()},
\code{\link{collapse_chars}()},
\code{\link{count_chars}()},
\code{\link{count_chars_words}()},
\code{\link{count_words}()},
\code{\link{invert_rules}()},
\code{\link{l33t_rul35}},
\code{\link{map_text_coord}()},
\code{\link{map_text_regex}()},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_chars}()},
\code{\link{text_to_sentences}()},
\code{\link{text_to_words}()},
\code{\link{transl33t}()},
\code{\link{words_to_text}()}
}
\concept{text objects and functions}
