% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds-describe.R
\name{ds_mdev}
\alias{ds_mdev}
\title{Mean Absolute Deviation}
\usage{
ds_mdev(data, x = NULL)
}
\arguments{
\item{data}{A numeric vector or \code{data.frame}.}

\item{x}{Column in \code{data}.}
}
\description{
Compute the mean absolute deviation about the mean
}
\details{
The \code{ds_mdev} function computes the mean absolute deviation
about the mean. It is different from \code{mad} in \code{stats} package as
the statistic used to compute the deviations is not \code{median} but
\code{mean}. Any NA values are stripped from \code{x} before computation
takes place
}
\examples{
# vector
ds_mdev(mtcars$mpg)

# data.frame
ds_mdev(mtcars, mpg)

}
\seealso{
\code{\link[stats]{mad}}
}
