% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds-freq-table.R
\name{ds_freq_table}
\alias{ds_freq_table}
\alias{plot.ds_freq_table}
\alias{ds_freq_cont}
\title{Frequency table}
\usage{
ds_freq_table(data, col, bins = 5)

\method{plot}{ds_freq_table}(x, print_plot = TRUE, ...)
}
\arguments{
\item{data}{A \code{data.frame} or a \code{tibble}.}

\item{col}{Column in \code{data}.}

\item{bins}{Number of intervals into which the data must be split.}

\item{x}{An object of class \code{ds_freq_table}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}

\item{...}{Further arguments to be passed to or from methods.}
}
\description{
Frequency table for categorical and continuous data and returns the
frequency, cumulative frequency, frequency percent and cumulative frequency
percent. \code{plot.ds_freq_table()} creates bar plot for the categorical
data and histogram for continuous data.
}
\examples{
# categorical data
ds_freq_table(mtcarz, cyl)

# barplot
k <- ds_freq_table(mtcarz, cyl)
plot(k)

# continuous data
ds_freq_table(mtcarz, mpg)

# barplot
k <- ds_freq_table(mtcarz, mpg)
plot(k)

}
\seealso{
\code{\link{ds_cross_table}}
}
