% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.ddt_lcm}
\alias{plot.ddt_lcm}
\title{Create trace plots of DDT-LCM parameters}
\usage{
\method{plot}{ddt_lcm}(
  x,
  parameter_names = c("responseprob_1,1,1", "classprob_1", "c", "diffusionvar_1"),
  burnin = 50,
  ...
)
}
\arguments{
\item{x}{a "ddt_lcm" object}

\item{parameter_names}{a character vector to specify the parameters to be plotted. Each element can take the
be 1) of format "parameter_index" to plot specific parameters with specific indices, 2) of format "parameter"
to plot the parameters across all indices, or 3) equal to "all" to plot all parameters in the model. For 1),
the item response probabilities should be named "responseprob_class,group,item"; the class probabilities should be
named "classprob_class"; the divergence function parameter is "c"; the group-specific diffusion variances
should be named "diffusionvar_group". For 2), "responseprob" to plot all item response probabilities;
"classprob" to plot all class probabilities; "diffusionvar" to plot all diffusion variances.}

\item{burnin}{the number of posterior samples as burn-in, which will not be plotted.}

\item{\dots}{Further arguments passed to each method}
}
\value{
NULLs
}
\description{
Create trace plots of DDT-LCM parameters
}
\examples{
data(result_diet_1000iters)
# Plot "c" for the divergence function parameter; "diffusionvar_1" for diffusion variance of group 1
plot(x = result_diet_1000iters, parameter_names = c("c", "diffusionvar_1"), burnin = 500)
# Plot "responseprob_1,1,1" for the class 1 response probability of item 3 in major group 2
plot(x = result_diet_1000iters, parameter_names = "responseprob_1,1,1", burnin = 500)
# Plot "classprob_1" for the probability of being assigned to class 1
plot(x = result_diet_1000iters, parameter_names = "classprob_1", burnin = 500)
# plot all class probabilities
plot(x = result_diet_1000iters, parameter_names = "classprob", burnin = 500)
# plot all diffusion variances
plot(x = result_diet_1000iters, "diffusionvar", burnin = 500)
}
