% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsides_parsers.R
\name{parseTWOSIDES}
\alias{parseTWOSIDES}
\title{Parse the TWOSIDES Drug-Drug Interaction Database}
\usage{
parseTWOSIDES(twosides_file_path, db_version = NULL, db_exported_date = NULL)
}
\arguments{
\item{twosides_file_path}{Path to the TWOSIDES data file (e.g., 'TWOSIDES.csv.gz').}

\item{db_version}{used twoside version (default = NULL)}

\item{db_exported_date}{used twoside release date (default = NULL)}
}
\value{
A dvobject of class `TWOSIDESDB` containing the `drug_drug_interactions`
  data frame and associated metadata.
}
\description{
Reads the \href{https://tatonettilab-resources.s3.amazonaws.com/nsides/TWOSIDES.csv.gz}{TWOSIDES} data file, which contains adverse event data for pairs of
drugs taken concurrently (N=2 interactions).
}
\details{
\href{https://tatonettilab-resources.s3.amazonaws.com/nsides/TWOSIDES.csv.gz}{TWOSIDES} is a database of drug-drug interaction safety signals
mined from the FDA's Adverse Event Reporting System using the same
approach as is used to generate OffSIDES.

Database fields as follow:
\describe{
\item{drug_1_rxnorn_id}{RxNORM identifier for drug 1}
\item{drug_1_concept_name}{RxNORM name string for drug 1}
\item{drug_2_rxnorm_id}{RxNORM identifier for drug 2}
\item{drug_2_concept_name}{RxNORM name string for drug 3}
\item{condition_meddra_id}{MedDRA identifier for the side effect}
\item{condition_concpet_name}{MedDRA name string for the side effect}
\item{A}{The number of reports for the pair of drugs that report the side effect}
\item{B}{The number of reports for the pair of drugs that do not report the side effect}
\item{C}{The number of reports for other PSM matched drugs (including perhaps the single versions of drug 1 or drug 2) that report the side effect}
\item{D}{The number of reports for other PSM matched drugs and other side effects}
\item{PRR}{Proportional reporting ratio, PRR=(A/(A+B))/(C/(C+D))}
\item{PRR_error}{Error estimate of the PRR}
\item{mean_reporting_frequency}{Proportion of reports for the drug that report the side effect, A/(A+B)}
}
}
\seealso{
Other parsers: 
\code{\link{cett_nodes_options}()},
\code{\link{drug_node_options}()},
\code{\link{parseDrugBank}()},
\code{\link{parseOnSIDES}()},
\code{\link{references_node_options}()}
}
\concept{parsers}
