% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/headache.R
\docType{data}
\name{headache}
\alias{headache}
\title{Headache Data for Three Way ANOVA}
\format{A data frame with 72 rows and 4 columns.}
\usage{
data("headache")
}
\description{
Measures of cholesterol concentration in 72 participants treated
 with three different drugs. The aim is to examine the potential of new class
 of drugs in lowering the cholesterol concentration and consequently reducing
 heart attack.

 A pharmaceutical company tested three treatments for migraine headache
 sufferers. 72 participants were enrolled in the experiments. The aim is to
 examine the potential of new class of treatments in lowering the pain score
 associated with the migraine headache episode.

 The participants include 36 males and 36 females. Males and females were
 further (equally) subdivided into whether they were at low or high risk of
 migraine headache.

 This data set is suited for three way Anova test.

 It contain the following variables: \itemize{ \item gender, which has two
 categories: "male" and "female"; \item risk which has two levels: "low" and
 "high" \item treatment, which has three categories: "X", "Y" and "Z". }
}
\examples{
data(headache)
head(as.data.frame(headache))
}
