#'Heart Attack Data for Three Way ANOVA
#'
#'@description Measures of cholesterol concentration in 72 participants treated
#'  with three different drugs. The aim is to examine the potential of new class
#'  of drugs in lowering the cholesterol concentration and consequently reducing
#'  heart attack.
#'
#'  The participants include 36 males and 36 females. Males and
#'  females were further (equally) subdivided into whether they were at low or
#'  high risk of heart attack.
#'
#'  This data set is suited for three way Anova test.
#'
#'  It contain the following variables: \itemize{ \item gender, which has two
#'  categories: "male" and "female"; \item risk which has two levels: "low" and
#'  "high"
#'  \item drug, which has three categories: "A", "B" and "C".
#'  }
#'@name heartattack
#'@docType data
#'@usage data("heartattack")
#'@format A data frame with 72 rows and 5 columns.
#' @examples
#' data(heartattack)
#' head(as.data.frame(heartattack))
NULL
