% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{plot_points}
\alias{plot_points}
\title{Plot points}
\usage{
plot_points(data, label_x = "", label_y = "", colors = NULL)
}
\arguments{
\item{data}{data.frame with category + one or more numeric columns}

\item{label_x}{x‑axis label}

\item{label_y}{y‑axis label}

\item{colors}{optional color vector for series}
}
\value{
returns a ggplot2::ggplot graphic
}
\description{
Dot chart for multiple series across categories (points only).
}
\details{
Expects a data.frame with category in the first column and one or more numeric series.
Points are colored by series (legend shows original column names). Supply \code{colors} to override the palette.
}
\examples{
x <- seq(0, 10, 0.25)
data <- data.frame(x, sin=sin(x), cosine=cos(x)+5)
head(data)

grf <- plot_points(data, colors=c("red", "green"))
plot(grf)
}
