% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cla_majority.R
\name{cla_majority}
\alias{cla_majority}
\title{Majority baseline classifier}
\usage{
cla_majority(attribute, slevels)
}
\arguments{
\item{attribute}{attribute target to model building.}

\item{slevels}{possible values for the target classification.}
}
\value{
returns a classification object.
}
\description{
Trivial classifier that always predicts the most frequent class observed in the training data.
Useful as a baseline.
}
\examples{
data(iris)
slevels <- levels(iris$Species)
model <- cla_majority("Species", slevels)

# preparing dataset for random sampling
sr <- sample_random()
sr <- train_test(sr, iris)
train <- sr$train
test <- sr$test

model <- fit(model, train)

prediction <- predict(model, test)
predictand <- adjust_class_label(test[,"Species"])
test_eval <- evaluate(model, predictand, prediction)
test_eval$metrics
}
