% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customiser.R
\name{customiser}
\alias{customiser}
\title{Create your .Rprofile from R Markdown}
\usage{
customiser(file, ..., quiet = FALSE)
}
\arguments{
\item{file}{Character. The R Markdown file from which to extract code.}

\item{...}{For future extensions and must be empty.}

\item{quiet}{Logical. Whether to silence the confirmation message.
\code{FALSE} by default.}
}
\value{
Invisibly, a string with the location of the .Rprofile file being
written to.
}
\description{
Mainly useful as the "knit:" parameter of an R Markdown file. A document with
this option will have its R code made into the contents of the appropriate
.Rprofile file for the user's operating system.
}
\details{
The function always writes the .Rprofile to R's home directory as determined
by \code{fs::path_home_r()}. If you wish to overwrite this behaviour, you can
set the "customiser.r_home" global option to the target directory of your
choosing.
}
\examples{
library(withr)
my_rmarkdown_file <- rmarkdown_simple()

tmp <- tempdir()

with_options(list(customiser.r_home = tmp), {
  customiser(my_rmarkdown_file)
})

file.exists(file.path(tmp, ".Rprofile"))
}
