% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{IncrementsHSRBeta-class}
\alias{IncrementsHSRBeta-class}
\alias{.IncrementsHSRBeta}
\alias{IncrementsHSRBeta}
\alias{.DefaultIncrementsHSRBeta}
\title{\code{IncrementsHSRBeta}}
\usage{
IncrementsHSRBeta(target = 0.3, prob = 0.95, a = 1, b = 1)

.DefaultIncrementsHSRBeta()
}
\arguments{
\item{target}{(\code{proportion})\cr see slot definition.}

\item{prob}{(\code{proportion})\cr see slot definition.}

\item{a}{(\code{number})\cr see slot definition.}

\item{b}{(\code{number})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{IncrementsHSRBeta}} is a class for limiting further increments using
a Hard Safety Rule based on the Bin-Beta model.
Increment control is based on the number of observed DLTs and number of
subjects at each dose level. The probability of toxicity is calculated
using a Bin-Beta model with prior (a,b). If the probability exceeds
the threshold for a given dose, that dose and all doses above are excluded
from further escalation.
This is a hard safety rule that limits further escalation based on the
observed data per dose level, independent from the underlying model.
}
\section{Slots}{

\describe{
\item{\code{target}}{(\code{proportion})\cr the target toxicity, except
0 or 1.}

\item{\code{prob}}{(\code{proportion})\cr the threshold probability (except 0 or 1) for
a dose being toxic.}

\item{\code{a}}{(\code{number})\cr shape parameter \eqn{a > 0} of probability distribution
Beta (a,b).}

\item{\code{b}}{(\code{number})\cr shape parameter \eqn{b > 0} of probability distribution
Beta (a,b).}
}}

\note{
Typically, end users will not use the \code{.DefaultIncrementsHSRBeta()} function.
}
\examples{
# Limit the escalation with a hard safety criteria to the doses that are below
# the first dose that is toxic with a probability of 0.95.
my_increments <- IncrementsHSRBeta(target = 0.3, prob = 0.95)
}
